<?php
namespace FacturaScripts\Plugins\ProyectosPro\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Tools;
use FacturaScripts\Core\Session;

class WidgetConfigUser extends ModelClass
{
    use ModelTrait;

    /** @var bool */
    public $active;

    /** @var string */
    public $creation_date;

    /** @var int */
    public $id;

    /** @var int */
    public $idwiget;

    /** @var string */
    public $last_nick;

    /** @var string */
    public $last_update;

    /** @var string */
    public $name;

    /** @var string */
    public $nick;

    /** @var string */
    public $nick;

    public function clear() 
    {
        parent::clear();
        $this->active = false;
        $this->idwiget = 0;
    }

    public static function primaryColumn(): string
    {
        return "id";
    }

    public static function tableName(): string
    {
        return "widgetconfigusers";
    }

    public function test(): bool
    {
        $this->creation_date = $this->creationdate ?? Tools::dateTime();
        $this->nick = $this->nick ?? Session::user()->nick;
        $this->name = Tools::noHtml($this->name);
        return parent::test();
    }

    protected function saveUpdate(array $values = [])
    {
        $this->last_nick = Session::user()->nick;
        $this->last_update = Tools::dateTime();
        return parent::saveUpdate($values);
    }
}
