<?php

namespace FacturaScripts\Plugins\ProTheme;

use FacturaScripts\Core\Template\InitClass;
use FacturaScripts\Core\Base\DataBase;
use FacturaScripts\Core\Model\Settings;

/**
 * Los plugins pueden contener un archivo Init.php en el que se definen procesos a ejecutar
 * cada vez que carga FacturaScripts o cuando se instala o actualiza el plugin.
 *
 * https://facturascripts.com/publicaciones/el-archivo-init-php-307
 */
class Init extends InitClass
{
    public function init(): void
    {
        // Se ejecuta en cada carga si el plugin está activo.
        // Migración de ajustes antiguos: select-menu -> select_menu
        $this->migrateSelectMenuSetting();
    }

    public function uninstall(): void
        {
            // se ejecuta cada vez que se desinstale el plugin. Primero desinstala y luego ejecuta el uninstall.
        }

    public function update(): void
    {
        // se ejecuta cada vez que se instala o actualiza el plugin
    }

    /**
     * Migra el ajuste antiguo con guion a uno válido para settings.
     */
    private function migrateSelectMenuSetting(): void
    {
        $db = new DataBase();

        if ($db->tableExists('settings')) {
            $settings = new Settings();
            if (false === $settings->load('theme')) {
                return;
            }

            $properties = $settings->getProperties();
            if (!array_key_exists('select-menu', $properties)) {
                return;
            }

            if (!array_key_exists('select_menu', $properties)) {
                $properties['select_menu'] = $properties['select-menu'];
            }

            unset($properties['select-menu']);
            $settings->setProperties($properties);
            $settings->save();
            return;
        }

        if (false === $db->tableExists('fs_settings')) {
            return;
        }

        // ¿existe el ajuste con guion?
        $old = $db->selectLimit(
            "SELECT value FROM fs_settings WHERE section = 'theme' AND name = 'select-menu'",
            1,
            0
        );
        if (empty($old)) {
            return;
        }

        $value = $old[0]['value'];

        // ¿ya existe el nuevo?
        $new = $db->selectLimit(
            "SELECT value FROM fs_settings WHERE section = 'theme' AND name = 'select_menu'",
            1,
            0
        );
        if (empty($new)) {
            $db->exec(
                "INSERT INTO fs_settings (section, name, value) VALUES ('theme', 'select_menu', " . $db->var2str($value) . ")"
            );
        }

        // borramos el antiguo para evitar errores futuros
        $db->exec('DELETE FROM fs_settings WHERE section = \'theme\' AND name = \'select-menu\'');
    }
}
