<?php

namespace FacturaScripts\Plugins\PartesSemanales\Model;

use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Session;
use FacturaScripts\Core\Tools;
use FacturaScripts\Dinamic\Model\Proyecto;
use FacturaScripts\Dinamic\Model\OIUser;
use FacturaScripts\Dinamic\Model\OIFichajes;
use FacturaScripts\Dinamic\Model\TareaProyecto;
use FacturaScripts\Dinamic\Model\FaseTarea;
use FacturaScripts\Core\Model\AttachedFileRelation;
use FacturaScripts\Dinamic\Model\AttachedFile;
use FacturaScripts\Plugins\Notificaciones\Lib\NotificationNotice;
use FacturaScripts\Dinamic\Lib\Email\TextBlock;
use FacturaScripts\Dinamic\Lib\Email\SpaceBlock;
use FacturaScripts\Dinamic\Model\UsuariosNotificaciones;
use FacturaScripts\Plugins\PartesSemanales\Model\Categoria;

class Partes extends ModelClass
{
    use ModelTrait;

    /** @var string */
    public $creationdate;

    /** @var int */
    public $id;

    /** @var string */
    public $lastnick;

    /** @var string */
    public $lastupdate;

    /** @var string */
    public $nick;

    /** @var int */
    public $idproyecto;



    public function clear()
    {
        parent::clear();
        $this->creationdate = date(self::DATETIME_STYLE);
        $this->nick = Session::get('user')->nick ?? null;
    }

    public function getProyecto(): Proyecto
    {
        $proyecto = new Proyecto();
        $proyecto->loadFromCode($this->idproyecto);
        return $proyecto;
    }

    public function getVehiculos(): array
    {
        $vehiculo = new OIVehiculoOrden();
        $where = [
            new DataBaseWhere('idorden', $this->id),
            new DataBaseWhere('nick', Session::get('user')->nick ?? null)
        ];
        return $vehiculo->all($where);
    }

    public function getMaterialPte(): array
    {
        $material = new OIMaterialProyecto();
        $where = [
            new DataBaseWhere('idproyecto', $this->idproyecto),
            new DataBaseWhere('idparte_dia', null)
        ];

        // Si el usuario no tiene un nivel elevado, limitamos a los materiales creados por él
        $user = Session::get('user');
        if (($user->level ?? 0) <= 90) {
            $where[] = new DataBaseWhere('nick', $user->nick ?? null);
        }

        return $material->all($where);
    }

    public function getIncidencias(): array
    {
        $incidencia = new OIncidencia();
        $where = [
            new DataBaseWhere('idorden', $this->id)
        ];

        $user = Session::get('user');
        if (($user->level ?? 0) <= 90) {
            $where[] = new DataBaseWhere('nick', $user->nick ?? null);
        }

        return $incidencia->all($where);
    }


    public static function primaryColumn(): string
    {
        return "id";
    }

    public static function tableName(): string
    {
        return "ordenes_instalacion";
    }

    public function test(): bool
    {
        $this->lastnick = Tools::noHtml($this->lastnick);
        $this->nick = Tools::noHtml($this->nick);
        return parent::test();
    }

    protected function saveInsert(array $values = []): bool
    {
        $this->lastupdate = null;
        $this->lastnick = null;
        $return = parent::saveInsert($values);
	return $return;
    }

    protected function saveUpdate(array $values = []): bool
    {
        $this->lastupdate = Tools::dateTime();
        $this->lastnick = Session::user()->nick;
        return parent::saveUpdate($values);
    }


	public function getFases()
	{
		return (new FaseTarea)->all();

	}

	public function getImagenesMaterial()
	{
		$material = new OIMaterialProyecto();
		$where = [new DataBaseWhere('idproyecto', $this->idproyecto)];
		$materiales = $material->all($where);

		$return = [];

		foreach($materiales as $material){

			$archivosTareas = new \FacturaScripts\Dinamic\Model\AttachedFile();
			$where = [
				new DataBaseWhere('idmaterial', $material->id),
			];
			$files = $archivosTareas->all($where);
			foreach($files as $file){
				$return[] = $file;
			}
		}
		return $return;
	}

	public function getPlanos()
	{

		$return = [];

		$where = [
			new DataBaseWhere('model', "Proyecto"),
			new DataBaseWhere('modelcode', $this->idproyecto),
			new DataBaseWhere('modelid', $this->idproyecto),
		];
		$fileRelation = new AttachedFileRelation();
		$planosRelation = $fileRelation->all($where);

		foreach($planosRelation as $planoRelation)
		{
			$where = [
				new DataBaseWhere('idfile', $planoRelation->idfile),
			];
			$newFile = new AttachedFile();
			$files = $newFile->all($where);
			foreach($files as $file){
				$file->observations = $planoRelation->observations;
				$return[] = $file;
			}
		}

		return $return;

	}

	public function getTareas($idorden=null)
	{
		$this->getPlanos();

		$return = [
			"tarea" => []
		];


		$task = new \FacturaScripts\Dinamic\Model\TareaProyecto();
		$where = [
			new DataBaseWhere('idproyecto', $this->idproyecto)
		];
		$tasks = $task->all($where);

		foreach($tasks as $task){

			if($task->idfase > 2){
				continue;
			}

			//si no es subtarea
			if($task->idtareapadre == ""){
				$return["tarea"][$task->idtarea] = $task;
			}
		}

		foreach($return["tarea"] as $tarea){

			if($idorden){
				if($tarea->idorden != $idorden){
					continue;
				}
			}

			$task = new \FacturaScripts\Dinamic\Model\TareaProyecto();
			$where = [
				new DataBaseWhere('idtareapadre', $tarea->idtarea)
			];
			$subtasks = $task->all($where);
			foreach($subtasks as $subTarea){

				$comentariosTareas = new \FacturaScripts\Dinamic\Model\OiComentariosTareas();
				$where = [
					new DataBaseWhere('idtarea', $subTarea->idtarea)
				];
				$comentariosTareas = $comentariosTareas->all($where);
				foreach($comentariosTareas as $comentario){
					$saveInfo = $this->decodeHtmlEntity($comentario->comentario);
					if($saveInfo)
						$subTarea->comentarios[] = $saveInfo;
				}

				$operarioSubTarea = new \FacturaScripts\Dinamic\Model\OIOperarioTarea();
				$where = [new DataBaseWhere('idtarea', $subTarea->idtarea)];
				$operariosModel = $operarioSubTarea->all($where);

				$subTarea->operarios = "";
				foreach($operariosModel as $operarioSubTarea){
					$subTarea->operarios = $operarioSubTarea->nick;
				}


				$archivosTareas = new \FacturaScripts\Dinamic\Model\AttachedFile();
				$where = [
					new DataBaseWhere('idtarea', $subTarea->idtarea),
				];
				$subTarea->files = $archivosTareas->all($where);

				$return["tarea"][$tarea->idtarea]->subtareas[] = $subTarea;
			}

			$archivosTareas = new \FacturaScripts\Dinamic\Model\AttachedFile();
			$where = [
				new DataBaseWhere('idtarea', $tarea->idtarea),
			];
			$archivosTareas = $archivosTareas->all($where);
			$return["tarea"][$tarea->idtarea]->files = $archivosTareas;

			$comentariosTareas = new \FacturaScripts\Dinamic\Model\OiComentariosTareas();
			$where = [
				new DataBaseWhere('idtarea', $tarea->idtarea)
			];
			$comentariosTareas = $comentariosTareas->all($where);
			foreach($comentariosTareas as $comentario){
				$saveInfo = $this->decodeHtmlEntity($comentario->comentario);
				if($saveInfo)
					$tarea->comentarios[] = $saveInfo;
			}

			$return["tarea"][$tarea->idtarea]->fichajes = (new OiFichajes)->getFichajes($tarea->idtarea);

			$operarioSubTarea = new \FacturaScripts\Dinamic\Model\OIOperarioTarea();
			$where = [new DataBaseWhere('idtarea', $tarea->idtarea)];
			$operarios = $operarioSubTarea->all($where);
			$return["tarea"][$tarea->idtarea]->operarios = $operarios;


			$where = [new DataBaseWhere('id', $tarea->idcategoria)];
			$categorias = (new Categoria)->all($where);

			$categoriaTarea = "";

			if($categorias){
				$categoriaTarea = $categorias[0]->categoria;
			}
		
			$return["tarea"][$tarea->idtarea]->categoria = $categoriaTarea;

			$return["tarea"][$tarea->idtarea]->fichaje_pendiente = $this->verificarFichajePendiente($tarea->idtarea);
		}

		$return['operariosList'] = (new OIUser)->getOperarios();

		return $return;

	}

private function verificarFichajePendiente($idtarea): ?OIFichajes
{
	$nick = Session::get('user')->nick; // Obtener el usuario actual
	$fichajes = new OIFichajes();

		$where = [
			new DataBaseWhere('idtarea', $idtarea), // Coincidir por tarea
			new DataBaseWhere('nick', $nick),      // Coincidir por usuario
			new DataBaseWhere('fin', null, '=', 'AND') // Verificar que 'fin' sea NULL
		];

		// Buscar registros que coincidan
		$fichajesPendientes = $fichajes->all($where);

		// Retornar el primero encontrado o NULL si no hay ninguno
	return !empty($fichajesPendientes) ? $fichajesPendientes[0] : null;
}

	private static function logDebug(string $message, array $context = []): void
	{
		try {
			$payload = json_encode($context, JSON_UNESCAPED_UNICODE | JSON_PARTIAL_OUTPUT_ON_ERROR);
		} catch (\Throwable $exception) {
			$payload = 'log-json-error: ' . $exception->getMessage();
		}

		Tools::log()->warning('[PartesSemanales] ' . $message . ' ' . $payload);
	}


	public function actualizarTarea()
	{
	if (!isset($_POST['update_task'])) {
		return;
	}

	self::logDebug('actualizarTarea:start', [
		'idtarea' => $_POST['idtarea'] ?? null,
		'esNuevaTarea' => $_POST['esNuevaTarea'] ?? null,
		'nombreTarea' => $_POST['nombreTarea'] ?? null,
		'idproyectoSeleccionado' => $_POST['idproyectoSeleccionado'] ?? null,
		'idproyecto' => $_POST['idproyecto'] ?? null,
		'files_count' => isset($_FILES['files']['tmp_name']) ? count((array) $_FILES['files']['tmp_name']) : 0,
		'filesSubtarea_count' => isset($_FILES['filesSubtarea']['tmp_name']) ? count((array) $_FILES['filesSubtarea']['tmp_name']) : 0,
	]);

		$esNuevaTarea = false;

		$modelTareas = null;

	if (isset($_POST['idtarea']) && $_POST['idtarea'] != "") {
		$idTarea = $_POST['idtarea'];
		$modelTareas = new TareaProyecto();
		$modelFichajes = new OiFichajes();
		$operarioTarea = new OIOperarioTarea();

			$where = [new DataBaseWhere('idtarea', $idTarea)];
			$operariosModel = $operarioTarea->all($where);

		foreach($operariosModel as $operario){
			$operario->delete();
		}
		$modelTareas->loadFromCode($idTarea);
		self::logDebug('actualizarTarea:modo', [
			'operacion' => 'update',
			'idtarea' => $idTarea,
			'idproyecto' => $modelTareas->idproyecto,
		]);
	}else{
		$modelTareas = new TareaProyecto();
		if(isset($_POST['esPlantilla']) && $_POST['esPlantilla'] == true){
			$modelTareas->plantillatarea = true;
		}
		$modelTareas->idproyecto = $_POST['idproyectoSeleccionado'];
		$modelTareas->nombre = $_POST['nombreTarea'];
		$modelTareas->cantidad = 1;
		self::logDebug('actualizarTarea:modo', [
			'operacion' => 'create',
			'idproyecto' => $_POST['idproyectoSeleccionado'] ?? null,
			'nombre' => $_POST['nombreTarea'] ?? null,
		]);
	}

		if (isset($_POST['nombreTarea'])) {
			$modelTareas->nombre = $_POST['nombreTarea'];
		}
		if (isset($_POST['descripcionTarea'])) {
			$descripcionTarea = $_POST['descripcionTarea'];
			$modelTareas->descripcion = strip_tags($descripcionTarea);
			$modelTareas->descripcionHTML = htmlspecialchars($descripcionTarea);
		}

		if (isset($_POST['idfase'])) {
			$idfase = $_POST['idfase'];
			$modelTareas->idfase = $idfase;
		}

		if (isset($_POST['idcategoria'])) {
			$idcategoria = $_POST['idcategoria'];
			$modelTareas->idcategoria = $idcategoria;
		}

		if (isset($_POST['idtipotarea'])) {
			$idtipotarea = $_POST['idtipotarea'];
			$modelTareas->idtipotarea = $idtipotarea;
		}

		if (isset($_POST['fecha'])) {
			$fecha = $_POST['fecha'];
			$modelTareas->fecha = $fecha;
		}

		if (isset($_POST['fechainicio'])) {
			$fechainicio = $_POST['fechainicio'];
			$modelTareas->fechainicio = $fechainicio;
		}

		if (isset($_POST['fechafin'])) {
			$fechafin = $_POST['fechafin'];
			$modelTareas->fechafin = $fechafin;
		}

		if (isset($_POST['idorden'])) {
			$idorden = $_POST['idorden'];
			if(!$modelTareas->idorden){
				$modelTareas->idorden = $idorden;
			}
		}

		if (isset($_POST['responsable'])) {
			$_POST['responsable'] = self::decodeJsonList($_POST['responsable']);
			$modelTareas->responsable = $_POST['responsable'][0] ?? null;

			if(!isset($_POST['operarios'])){
				$_POST['operarios'] = [];
			}
			$_POST['operarios'] = self::decodeJsonList($_POST['operarios']);

			$existeElOperario = false;

			foreach($_POST['operarios'] as $operario){
				$partes = explode("_", $operario);
				$operarioName = $partes[0];
				if($operarioName == $modelTareas->responsable){
					$existeElOperario = true;
				}
			}

			if(!$existeElOperario && $modelTareas->responsable){
				$_POST['operarios'][] = $modelTareas->responsable . "_1";
			}

		}else{
			$modelTareas->responsable = null;
		}

	if($modelTareas !=null){
		if(!empty($_POST['esNuevaTarea'])){
			$modelTareas->idtarea = null;
			$esNuevaTarea = true;
			self::logDebug('actualizarTarea:nueva', [
				'post_idtarea' => $_POST['idtarea'] ?? null,
			]);
		}
		if (false === $modelTareas->save()) {
			Tools::log()->error('No se ha podido guardar la tarea semanal. Revisa los campos obligatorios.');
			return;
		}

		$idTarea = $modelTareas->idtarea;
		self::logDebug('actualizarTarea:guardado', [
			'idtarea' => $idTarea,
			'esNuevaTarea' => $esNuevaTarea,
		]);

			
			if($modelTareas->idfase == 3){
				$notificaciones = new UsuariosNotificaciones();
				$notificaciones->send(UsuariosNotificaciones::COMPLETAR_TAREA, $modelTareas);
			}

		}

/*
		if (isset($_POST['horaInicio'])) {
			$modelFichajes->inicio = $_POST['horaInicio'];
		}

		if (isset($_POST['horaFin'])) {
			$modelFichajes->fin = $_POST['horaFin'];
			if (isset($_POST['nickFichaje'])) {
				$modelFichajes->nick = $_POST['nickFichaje'];
			}else{
				$nick = Session::get('user')->nick ?? null;
				if($nick){
					$modelFichajes->nick = $nick;
				}
			}
			$modelFichajes->idtarea = $idTarea;
			$modelFichajes->save();
		}
*/
		if (isset($_POST['operarios'])) {

			$operarios = $_POST['operarios'];

			foreach($operarios as $operario){
				$operarioTarea = new OIOperarioTarea();
				$operarioTarea->horas = 1;
				$operarioTarea->idtarea = $idTarea;
				$operarioTarea->lastnick = "test";
				$operarioTarea->lastupdate = date("d-m-Y H:i:s");
				$partes = explode("_", $operario);
				$operarioTarea->nick = $partes[0];
				$operarioTarea->save();
			}
				
		}

		$operarioTarea = new \FacturaScripts\Dinamic\Model\OIOperarioTarea();
		$where = [new DataBaseWhere('idtarea', $idTarea)];
		$operariosModel = $operarioTarea->all($where);

		foreach($operariosModel as $operario){

			$fechainicio = "";
			$fechafin = "";

			$fichajeiniciotxt = 'fichajeinicio_' . $operario->nick;
			$fichajefintxt = 'fichajefin_' . $operario->nick;

			if(isset($_POST[$fichajeiniciotxt]) && $_POST[$fichajeiniciotxt]){
				$fechainicio = $_POST[$fichajeiniciotxt];			
			}

			if(isset($_POST[$fichajefintxt]) && $_POST[$fichajefintxt]){
				$fechafin = $_POST[$fichajefintxt];			
			}

			if($fechainicio && $fechafin){
				$modelFichajes = new OiFichajes();
				$modelFichajes->inicio = $fechainicio;
				$modelFichajes->fin = $fechafin;
				$modelFichajes->nick = $operario->nick;
				$modelFichajes->idtarea = $idTarea;
				$modelFichajes->save();
			}

			$fichajes = (new OiFichajes)->getFichajesByNickIdTarea($operario->nick, $idTarea);

			$totalHorasTrabajadas = 0;
			
			foreach ($fichajes as $fichaje)
			{
				$inicio = new \DateTime();
				$inicio->setTimestamp(strtotime($fichaje->inicio));

				$fin = new \DateTime();
				$fin->setTimestamp(strtotime($fichaje->fin));

				$diferencia = $inicio->diff($fin);
				$totalHorasTrabajadas += $diferencia->h + ($diferencia->days * 24);
			}
/*
			$inicio = new \DateTime();
			$inicio->setTimestamp(strtotime($fichaje->inicio));

			$fin = new \DateTime();
			$fin->setTimestamp(strtotime($fichaje->fin));

			// Calcular la diferencia entre las fechas
			$diferencia = $inicio->diff($fin);
			// Sumar las horas de diferencia al total
			$totalHorasTrabajadas += $diferencia->h + ($diferencia->days * 24);
*/
			$operario->horas = $totalHorasTrabajadas;
			$operario->save();
		}

	if (isset($_FILES['files']) && is_array($_FILES['files']['tmp_name'])) {
		$this->guardarImagenTarea($_FILES['files'], $idTarea);
		self::logDebug('actualizarTarea:imagenes-tarea', [
			'idtarea' => $idTarea,
			'cantidad' => count((array) $_FILES['files']['tmp_name']),
		]);
	}

	if (isset($_FILES['filesSubtarea']) && is_array($_FILES['filesSubtarea']['tmp_name']) && isset($_POST['idtareaSubtarea'])) {
		$this->guardarImagenTarea($_FILES['filesSubtarea'], $_POST['idtareaSubtarea']);
		self::logDebug('actualizarTarea:imagenes-subtarea', [
			'idtarea' => $idTarea,
			'referencias' => $_POST['idtareaSubtarea'],
			'cantidad' => count((array) $_FILES['filesSubtarea']['tmp_name']),
		]);
	}

		if (isset($_POST['checklist'])) {

			$checklist = self::normalizeChecklistItems($_POST['checklist']);

			$where = [
				new DataBaseWhere('idtareapadre', $idTarea),
			];
			$modelSubTask = (new TareaProyecto())->all($where, []);

			$delSubTasks = [];

			foreach($modelSubTask as $subtarea){
				$delSubTasks[$subtarea->idtarea] = $subtarea;
			}

			foreach($checklist as $subtarea){

				if(isset($delSubTasks[$subtarea['id']])){
					unset($delSubTasks[$subtarea['id']]);
				}

				$modelSubTask = new TareaProyecto();
				$where = [new DataBaseWhere('idtarea', $subtarea['id'])];
				$subTask = $modelSubTask->all($where);

				if(count($subTask) > 0 && !$esNuevaTarea){
					$modelSubTask = $subTask[0];

			if (isset($_POST['subTareas'])) {
				$subTareas = self::normalizeSubtaskItems($_POST['subTareas']);
						foreach($subTareas as $subTareaModal){
							if($subTareaModal['idtarea'] == $modelSubTask->idtarea){
								$modelSubTask->descripcion = $subTareaModal['descripcion'];
								$modelSubTask->hora_inicio = $subTareaModal['hora_inicio'];
								$modelSubTask->hora_fin = $subTareaModal['hora_fin'];
								$modelSubTask->nombre = $subtarea['descripcion'];
								if(!$modelSubTask->checked){
									$modelSubTask->checked = $subtarea['marcado'];
								}
								$modelSubTask->save();

								if(isset($subTareaModal['comentarios']))
									$this->saveComentarios($subTareaModal['comentarios'], $modelSubTask->idtarea);

							}

							if(isset($subTareaModal['operarios'])){
								$operarios = $subTareaModal['operarios'];
								if(is_array($operarios) && count($operarios) > 0){

									foreach($operarios as $operario){
										$operarioTarea = new OIOperarioTarea();
										$operarioTarea->horas = 1;
										$operarioTarea->idtarea = $subTareaModal['idtarea'];
										$operarioTarea->lastnick = "test";
										$operarioTarea->lastupdate = date("d-m-Y H:i:s");
										$partes = explode("_", $operario);
										$operarioTarea->nick = $partes[0];
										$operarioTarea->save();
									}
								}
							}
						}
					}

		}else{
			//COMPLETAMENTE NUEVA
			$modelSubTask = new TareaProyecto();
			$modelSubTask->idtareapadre = $idTarea;
			$modelSubTask->idproyecto = $modelTareas->idproyecto;
			$modelSubTask->nombre = $subtarea['descripcion'];
			$modelSubTask->checked = $subtarea['marcado'];
			$modelSubTask->cantidad = 0;
			$modelSubTask->idfase = 1;
			$modelSubTask->idcategoria = 0;
			$modelSubTask->save();
			self::logDebug('actualizarTarea:subtarea-nueva', [
				'idtarea_nueva' => $modelSubTask->idtarea,
				'id_temporal' => $subtarea['id'],
			]);

			$tempId = self::normalizeAttachmentId($subtarea['id']);
			$archivosTemporales = new \FacturaScripts\Dinamic\Model\AttachedFile();
			$whereTemp = [new DataBaseWhere('idtarea', $tempId)];
			foreach ($archivosTemporales->all($whereTemp) as $archivoTmp) {
				$archivoTmp->idtarea = $modelSubTask->idtarea;
				$archivoTmp->save();
				self::logDebug('actualizarTarea:subtarea-imagen-remapeada', [
					'archivo' => $archivoTmp->idfile,
					'origen' => $tempId,
					'destino' => $modelSubTask->idtarea,
				]);
			}
		}

			}

			foreach($delSubTasks as $del){
				$del->delete();
			}

		}

		if (isset($_POST['comentarios'])) {

			$this->saveComentarios($_POST['comentarios'], $idTarea);
		}
		if(isset($_POST['imagenesBorradas'])){
			$entrada = $_POST['imagenesBorradas'];
			$urls = explode(',', $entrada);

			foreach ($urls as $url) {
				$urlParts = explode('?myft=', $url);

				$path = $urlParts[0];

				$archivosTareas = new \FacturaScripts\Dinamic\Model\AttachedFile();
				$where = [
					    new DataBaseWhere('path', $path)
				];
				$archivosTareas = $archivosTareas->all($where);
				foreach($archivosTareas as $archivo){
					$archivo->delete();
				}
			}

		}
	if(isset($_POST['baseidtareaimagen'])){
		$idtareaimagen = $_POST['baseidtareaimagen'];
		$archivosTareas = new \FacturaScripts\Dinamic\Model\AttachedFile();
		$where = [
			new DataBaseWhere('idtarea', $idtareaimagen)
		];
		$archivosTareas = $archivosTareas->all($where);
		foreach($archivosTareas as $archivo){
			$archivo->idtarea = $modelTareas->idtarea;
			$archivo->save();
			self::logDebug('actualizarTarea:imagenes-transferidas', [
				'archivo' => $archivo->idfile,
				'origen' => $idtareaimagen,
				'destino' => $modelTareas->idtarea,
			]);
		}
	}

	self::logDebug('actualizarTarea:fin', [
		'idtarea' => $idTarea,
		'checklist_procesados' => isset($checklist) ? count($checklist) : 0,
	'subtareas_procesadas' => isset($subTareas) ? count($subTareas) : 0,
	]);

	return $idTarea;
}


	private static function flattenItems(array $items, array $requiredKeys): array
	{
		$result = [];
		$stack = $items;
		while ($stack) {
			$item = array_shift($stack);
			if (!is_array($item)) {
				continue;
			}

			$hasAllKeys = true;
			foreach ($requiredKeys as $key) {
				if (!array_key_exists($key, $item)) {
					$hasAllKeys = false;
					break;
				}
			}

			if ($hasAllKeys) {
				$result[] = $item;
				continue;
			}

			foreach ($item as $value) {
				if (is_array($value)) {
					$stack[] = $value;
				}
			}
		}

		return $result;
	}

private static function normalizeChecklistItems($value): array
{
	$items = self::flattenItems(self::decodeJsonArray($value), ['id', 'descripcion', 'marcado']);
	self::logDebug('actualizarTarea:checklist-normalizada', [
		'entrada' => is_string($value) ? $value : json_encode($value, JSON_UNESCAPED_UNICODE | JSON_PARTIAL_OUTPUT_ON_ERROR),
		'cantidad' => count($items),
	]);
	return $items;
}

		private static function decodeJsonList($value): array
	{
		if (is_array($value)) {
			return $value;
		}

		if (is_string($value)) {
			$decoded = json_decode($value, true);
			if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
				return $decoded;
			}
		}

		return $value === null || $value === '' ? [] : [$value];
	}

private static function normalizeAttachmentId($id): int
	{
		if (is_array($id)) {
			$id = reset($id);
		}

		if ($id === null || $id === '' || $id === false) {
			return 0;
		}

		if (is_numeric($id) && (string) (int) $id === trim((string) $id)) {
			return (int) $id;
		}

		$hash = crc32((string) $id);
		if ($hash >= 0) {
			$hash = -($hash + 1);
		}

		return (int) $hash;
	}

private static function normalizeSubtaskItems($value): array
{
	$result = self::flattenItems(self::decodeJsonArray($value), ['idtarea']);
	self::logDebug('actualizarTarea:subtareas-normalizadas', [
		'entrada' => is_string($value) ? $value : json_encode($value, JSON_UNESCAPED_UNICODE | JSON_PARTIAL_OUTPUT_ON_ERROR),
		'cantidad' => count($result),
	]);
	return $result;
}
	function saveComentarios($comentarios = null, $idTarea=null){

		if ($comentarios) {
			$comentariosTareas = new \FacturaScripts\Dinamic\Model\OiComentariosTareas();
			$comentariosTareas->comentario = $comentarios;
			$comentariosTareas->idtarea = $idTarea;
			$comentariosTareas->save();
		}
	}

	private static function decodeJsonArray($value): array
	{
		if ($value === null) {
			return [];
		}

		if (!is_array($value)) {
			$value = [$value];
		}

		$result = [];
		foreach ($value as $item) {
			if (is_string($item)) {
				$decoded = json_decode($item, true);
				if (json_last_error() === JSON_ERROR_NONE) {
					$result[] = $decoded;
					continue;
				}
			}
			$result[] = $item;
		}

		return $result;
	}

	public function guardarImagenTarea($files, $idtarea)
	{
		$idtareaParam = $idtarea;
		try{
			$carpetaDestino = FS_FOLDER . '/MyFiles/';

			if(!is_array($files['tmp_name'])){
				return;
			}

			foreach ($files['tmp_name'] as $key => $tmp_name) {
				if(is_array($idtareaParam)){
					$idtarea = $idtareaParam[$key];
				}
				$nombreArchivo = $files['name'][$key];
				$rutaArchivo = $carpetaDestino . $nombreArchivo;

				$nombreOriginal = $files['name'][$key];
				$nombreLimpio = preg_replace('/[^a-zA-Z0-9]+/', '_', $nombreOriginal);
				$nombreLimpio = trim($nombreLimpio, '_');

				if(move_uploaded_file($tmp_name, $rutaArchivo)){
					$archivosTareas = new \FacturaScripts\Dinamic\Model\AttachedFile();
					$where = [
						new DataBaseWhere('idtarea', $idtarea),
						    new DataBaseWhere('path', $rutaArchivo),
					];
					$archivosTareas = $archivosTareas->all($where);

					if($archivosTareas){
						foreach($archivosTareas as $file){
							$file->path = $nombreArchivo;
							$file->save();
							$file->filename = $nombreLimpio;
							$file->save();
						}
					}else{
						$archivosTareas = new \FacturaScripts\Dinamic\Model\AttachedFile();
						$archivosTareas->idtarea = $idtarea;
						$archivosTareas->path = $nombreArchivo;
						$archivosTareas->save();
						$archivosTareas->filename = $nombreLimpio;
						$archivosTareas->save();
					}
				}
			}
		}catch(FileNotFoundException $e){

		}
	}

	public function decodeHtmlEntity($str) {

		$str = strip_tags($str);

		$entities = array(
				'lt' => '<',
				'gt' => '>',
				'amp' => '&',
				);

		$return = preg_replace_callback('/&([a-z]+);/i', function($match) use ($entities) {
				return isset($entities[$match[1]]) ? $entities[$match[1]] : $match[0];
				}, $str);
		return strip_tags($return);


	}

	public function guardarImagenMaterial($files, $idMaterial){
		$carpetaDestino = FS_FOLDER . '/MyFiles/';



		foreach ($files['tmp_name'] as $key => $tmp_name) {
			$nombreArchivo = $files['name'][$key];
			$rutaArchivo = $carpetaDestino . $nombreArchivo;

			$nombreOriginal = $files['name'][$key];
			$nombreLimpio = preg_replace('/[^a-zA-Z0-9]+/', '_', $nombreOriginal);
			$nombreLimpio = trim($nombreLimpio, '_');

			if(move_uploaded_file($tmp_name, $rutaArchivo)){
				$archivosTareas = new \FacturaScripts\Dinamic\Model\AttachedFile();
				$where = [
					new DataBaseWhere('idmaterial', $idMaterial),
					    new DataBaseWhere('path', $rutaArchivo),
				];
				$archivosTareas = $archivosTareas->all($where);

				if($archivosTareas){
					foreach($archivosTareas as $file){
						$file->path = $nombreArchivo;
						$file->save();
						$file->filename = $nombreLimpio;
						$file->save();
					}
				}else{
					$archivosTareas = new \FacturaScripts\Dinamic\Model\AttachedFile();
					$archivosTareas->idmaterial = $idMaterial;
					$archivosTareas->path = $nombreArchivo;
					$archivosTareas->save();
					$archivosTareas->filename = $nombreLimpio;
					$archivosTareas->save();
				}
			}
			
		}

	}

	public function guardarIncidencia($files, $data){
		$carpetaDestino = FS_FOLDER . '/MyFiles/';

		$incidencia = new OIncidencia();
                $incidencia->idorden = $data['idorden'];
                $incidencia->descripcion_incidencia = $data['descripcion'];
                $incidencia->idproyecto = $data['idproyecto'];
                if(isset($data['iddia'])){
                    $incidencia->iddia = (int) $data['iddia'];
                }
                $incidencia->name = $data['titulo'];
		$incidencia->nick = Session::get('user')->nick;
		$incidencia->lastnick = Session::get('user')->nick;
		$incidencia->estado = "pendiente";
		$incidencia->save();

		$notificaciones = new UsuariosNotificaciones();
		$notificaciones->send(UsuariosNotificaciones::CREAR_INCIDENCIA, $incidencia);

		if(!is_array($files['tmp_name'])){
			return;
		}

		foreach ($files['tmp_name'] as $key => $tmp_name) {
			$nombreArchivo = $files['name'][$key];
			$rutaArchivo = $carpetaDestino . $nombreArchivo;

			$nombreOriginal = $files['name'][$key];
			$nombreLimpio = preg_replace('/[^a-zA-Z0-9]+/', '_', $nombreOriginal);
			$nombreLimpio = trim($nombreLimpio, '_');

			if(move_uploaded_file($tmp_name, $rutaArchivo)){
				$archivosTareas = new \FacturaScripts\Dinamic\Model\AttachedFile();
				$where = [
					new DataBaseWhere('idincidencia', $incidencia->id),
					    new DataBaseWhere('path', $rutaArchivo),
				];
				$archivosTareas = $archivosTareas->all($where);

				if($archivosTareas){
					foreach($archivosTareas as $file){
						$file->path = $nombreArchivo;
						$file->save();
						$file->filename = $nombreLimpio;
						$file->save();
					}
				}else{
					$archivosTareas = new \FacturaScripts\Dinamic\Model\AttachedFile();
					$archivosTareas->idincidencia = $incidencia->id;
					$archivosTareas->path = $nombreArchivo;
					$archivosTareas->save();
					$archivosTareas->filename = $nombreLimpio;
					$archivosTareas->save();
				}
			}
		}

	}

}
