<?php

namespace FacturaScripts\Plugins\PartesSemanales\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Plugins\PartesSemanales\Model\OIVehiculoOrden;
use FacturaScripts\Plugins\PartesSemanales\Model\OIMaterialProyecto;
use FacturaScripts\Plugins\PartesSemanales\Model\OIChecklistDia;
use FacturaScripts\Core\Session;

class ParteSemanalDia extends ModelClass
{
    use ModelTrait;

    /** @var int */
    public $id;

    /** @var int */
    public $idparte;

    /** @var int */
    public $dia;

    /** @var float */
    public $horas;

    /** @var float */
    public $horas_extra;

    /** @var int */
    public $comidas;

    /** @var float */
    public $dietas;

    /** @var string */
    public $nick;

    public function clear()
    {
        parent::clear();
        $this->horas = 0;
        $this->horas_extra = 0;
        $this->comidas = 0;
        $this->dietas = 0;
        $this->nick = Session::get('user')->nick ?? null;
    }

    public static function primaryColumn(): string
    {
        return 'id';
    }

    public static function tableName(): string
    {
        return 'oi_parte_semanal_dias';
    }

    public function getVehiculos(): array
    {
        $vehiculo = new OIVehiculoOrden();
        $where = [
            new DataBaseWhere('idparte_dia', $this->id),
            new DataBaseWhere('nick', Session::get('user')->nick ?? null)
        ];
        return $vehiculo->all($where);
    }

    public function getMateriales(): array
    {
        $material = new OIMaterialProyecto();
        $where = [
            new DataBaseWhere('idparte_dia', $this->id)
        ];

        // Mostrar materiales de todos los usuarios solo para perfiles de alto nivel
        $user = Session::get('user');
        if (($user->level ?? 0) <= 90) {
            $where[] = new DataBaseWhere('nick', $user->nick ?? null);
        }
        return $material->all($where);
    }

    public function getChecklists(): array
    {
        $check = new OIChecklistDia();
        $where = [
            new DataBaseWhere('idparte_dia', $this->id),
            new DataBaseWhere('nick', Session::get('user')->nick ?? null)
        ];
        return $check->all($where, ['id' => 'ASC']);
    }
}
