<?php

namespace FacturaScripts\Plugins\PartesSemanales\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Session;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Plugins\PartesSemanales\Model\OIncidencia;

class ParteSemanal extends ModelClass
{
    use ModelTrait;

    /** @var int */
    public $id;

    /** @var string */
    public $nick;

    /** @var string */
    public $fechainicio;

    /** @var string */
    public $fechafin;

    /** @var int|null */
    public $idproyecto;

    /** @var int|null */
    public $idalbaran;

    /** @var string|null */
    public $semana;

    public function clear()
    {
        parent::clear();
        $this->fechainicio = date('Y-m-d');
        $this->fechafin = date('Y-m-d', strtotime('+6 days'));
        $this->nick = Session::get('user')->nick ?? '';
        $this->idalbaran = null;
    }

    public static function primaryColumn(): string
    {
        return 'id';
    }

    public static function tableName(): string
    {
        return 'oi_parte_semanal';
    }

    public function getProyecto(): \FacturaScripts\Dinamic\Model\Proyecto
    {
        $proyecto = new \FacturaScripts\Dinamic\Model\Proyecto();
        $proyecto->loadFromCode($this->idproyecto);
        return $proyecto;
    }

    public function getAlbaran(): ?\FacturaScripts\Dinamic\Model\AlbaranCliente
    {
        if (empty($this->idalbaran)) {
            return null;
        }

        $albaran = new \FacturaScripts\Dinamic\Model\AlbaranCliente();
        if (false === $albaran->loadFromCode($this->idalbaran)) {
            $this->idalbaran = null;
            $this->save();
            return null;
        }

        return $albaran;
    }

    public function getPlanos(): array
    {
        $return = [];

        $where = [
            new \FacturaScripts\Core\Base\DataBase\DataBaseWhere('model', 'Proyecto'),
            new \FacturaScripts\Core\Base\DataBase\DataBaseWhere('modelcode', $this->idproyecto),
            new \FacturaScripts\Core\Base\DataBase\DataBaseWhere('modelid', $this->idproyecto),
        ];
        $fileRelation = new \FacturaScripts\Core\Model\AttachedFileRelation();
        $planosRelation = $fileRelation->all($where);

        foreach ($planosRelation as $planoRelation) {
            $where = [
                new \FacturaScripts\Core\Base\DataBase\DataBaseWhere('idfile', $planoRelation->idfile),
            ];
            $newFile = new \FacturaScripts\Core\Model\AttachedFile();
            $files = $newFile->all($where);
            foreach ($files as $file) {
                $file->observations = $planoRelation->observations;
                $return[] = $file;
            }
        }

        return $return;
    }

    public function getIncidencias(): array
    {
        $incidencia = new OIncidencia();
        $where = [new DataBaseWhere('idorden', $this->id)];

        // Filtrar por usuario salvo para perfiles con nivel alto
        $user = Session::get('user');
        if (($user->level ?? 0) <= 90) {
            $where[] = new DataBaseWhere('nick', $user->nick ?? null);
        }
        return $incidencia->all($where, ['iddia' => 'ASC']);
    }

    public function getResumen(): array
    {
        $diaModel = new ParteSemanalDia();
        $dias = $diaModel->all([new DataBaseWhere('idparte', $this->id)]);

        $resumen = [
            'horas' => 0.0,
            'horas_extra' => 0.0,
            'comidas' => 0,
            'dietas' => 0.0,
            'kms' => 0.0,
            'materiales' => 0.0,
        ];

        foreach ($dias as $dia) {
            $resumen['horas'] += (float) $dia->horas;
            $resumen['horas_extra'] += (float) $dia->horas_extra;
            $resumen['comidas'] += (int) $dia->comidas;
            $resumen['dietas'] += (float) $dia->dietas;

            foreach ($dia->getVehiculos() as $vehiculo) {
                $resumen['kms'] += max(0, $vehiculo->km_fin - $vehiculo->km_ini);
            }

            foreach ($dia->getMateriales() as $material) {
                $resumen['materiales'] += (float) $material->cantidad;
            }
        }

        return $resumen;
    }

    /**
     * Returns a label for the week. If a number is provided, it is used as the
     * week index. Otherwise the calendar week is used.
     */
    public function getSemana(?int $numero = null): string
    {
        $start = date('d-m-Y', strtotime($this->fechainicio));
        $end = date('d-m-Y', strtotime($this->fechafin));
        $week = $numero ?? (int) date('W', strtotime($this->fechainicio));

        return 'Semana ' . $week . ' (' . $start . ' - ' . $end . ')';
    }
}
