<?php

namespace FacturaScripts\Plugins\PartesSemanales\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Tools;

class OiVehiculo extends ModelClass
{
    use ModelTrait;

    /** @var float */
    public $coste_dia;

    /** @var float */
    public $coste_km;

    /** @var string */
    public $fecha_baja;

    /** @var int */
    public $id_vehiculo;

    /** @var string */
    public $matricula;

    /** @var string */
    public $modelo_vehiculo;

    public function clear()
    {
        parent::clear();
        $this->coste_dia = 0.0;
        $this->coste_km = 0.0;
    }

    public static function primaryColumn(): string
    {
        return "id_vehiculo";
    }

    public static function tableName(): string
    {
        return "oi_vehiculos";
    }

    public function test(): bool
    {
        $this->matricula = Tools::noHtml($this->matricula);
        $this->modelo_vehiculo = Tools::noHtml($this->modelo_vehiculo);
        return parent::test();
    }

}
