<?php

namespace FacturaScripts\Plugins\PartesSemanales\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Session;

class OIVehiculoOrden extends ModelClass
{
    use ModelTrait;

    /** @var string */
    public $creationdate;

    /** @var int */
    public $id;

    /** @var int */
    public $idorden;

    /** @var int */
    public $idvehiculo;

    /** @var int|null */
    public $idparte_dia;

    /** @var float|null */
    public $km_fin;

    /** @var float */
    public $km_ini;

    /** @var string */
    public $lastnick;

    /** @var string */
    public $lastupdate;

    /** @var string */
    public $nick;

    public function clear()
    {
        parent::clear();
        $this->creationdate = date(self::DATETIME_STYLE);
        $this->km_fin = null;
        $this->km_ini = 0.0;
        $this->idparte_dia = null;
        $this->nick = Session::get('user')->nick ?? null;
    }

    public function getVehiculo()
    {
        $vehiculo = new OiVehiculo();
        $vehiculo->loadFromCode($this->idvehiculo);
        return $vehiculo;
    }

    public static function primaryColumn(): string
    {
        return "id";
    }

    public static function tableName(): string
    {
        return "oi_vehiculos_ordenes";
    }

    public function test(): bool
    {
        $this->lastnick = $this->toolBox()->utils()->noHtml($this->lastnick);
        $this->nick = $this->toolBox()->utils()->noHtml($this->nick);
        return parent::test();
    }

    protected function saveInsert(array $values = []): bool
    {
        $this->lastupdate = date(self::DATETIME_STYLE);
        $this->lastnick = Session::get('user')->nick ?? null;
        return parent::saveInsert($values);
    }

    protected function saveUpdate(array $values = []): bool
    {
        $this->lastupdate = date(self::DATETIME_STYLE);
        $this->lastnick = Session::get('user')->nick ?? null;
        return parent::saveUpdate($values);
    }
}
