<?php

namespace FacturaScripts\Plugins\PartesSemanales\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Session;
use FacturaScripts\Core\Tools;
use FacturaScripts\Dinamic\Model\Proyecto;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;

class OIMaterialProyecto extends ModelClass
{
    use ModelTrait;

    /** @var int */
    public $cantidad;

    /** @var string */
    public $creationdate;

    /** @var string */
    public $descripcion;

    /** @var int */
    public $id;

    /** @var int */
    public $idproyecto;

    /** @var int|null */
    public $idparte_dia;

    /** @var string */
    public $lastnick;

    /** @var string */
    public $lastupdate;

    /** @var string */
    public $nick;

    /** @var bool */
    public $pendiente;

    /** @var string */
    public $referencia;

    public function clear()
    {
        parent::clear();
        $this->cantidad = 0;
        $this->creationdate = date(self::DATETIME_STYLE);
        $this->idproyecto = 0;
        $this->idparte_dia = null;
        $this->nick = Session::get('user')->nick ?? null;
        $this->pendiente = false;
    }

    public static function primaryColumn(): string
    {
        return "id";
    }

    public static function tableName(): string
    {
        return "oi_material_proyecto";
    }

    public function test(): bool
    {
        $this->descripcion = Tools::noHtml($this->descripcion);
        $this->lastnick = Tools::noHtml($this->lastnick);
        $this->nick = Tools::noHtml($this->nick);
        return parent::test();
    }

    protected function saveInsert(array $values = []): bool
    {
        $this->lastupdate = null;
        $this->lastnick = null;
        return parent::saveInsert($values);
    }

    protected function saveUpdate(array $values = []): bool
    {
        $this->lastupdate = date(self::DATETIME_STYLE);
        $this->lastnick = Session::get('user')->nick ?? null;
        return parent::saveUpdate($values);
    }

    public function url(string $type = 'auto', string $list = 'List'): string
    {
        // Si el tipo que estamos pidiendo la URL del listado, devuelve la  URL del proyecto.
        return $type == 'list' ?
            $this->getProyecto()->url() :
            parent::url($type, $list);
    }

    public function getProyecto(): Proyecto
    {
        $proyecto = new Proyecto();
        $proyecto->loadFromCode($this->idproyecto);
        return $proyecto;
    }
}
