<?php
namespace FacturaScripts\Plugins\PartesSemanales\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Dinamic\Model\TareaProyecto;
use FacturaScripts\Dinamic\Model\User;
use FacturaScripts\Dinamic\Model\OIOperarioTarea;

class OIFichajes extends ModelClass
{
    use ModelTrait;

    /** @var int */
    public $id;
    /** @var string */
    public $fin;

    /** @var int */
    public $idtarea;

    /** @var string */
    public $inicio;

    /** @var string */
    public $nick;

    /** @var string */
    public $horas;

    public function clear() 
    {
        parent::clear();
        $this->fin = date(self::DATE_STYLE);
        $this->idtarea = 0;
        $this->inicio = date(self::DATE_STYLE);
    }

    public static function primaryColumn(): string
    {
        return "id";
    }

    public static function tableName(): string
    {
        return "oi_fichajes";
    }

    public function test(): bool
    {
        return parent::test();
    }



    public function getFichajes($idtarea){
	    $where = [new DataBaseWhere('idtarea', $idtarea)];
	    return $this->all($where);
    }

    public function getFichajesByNick($operario){
	    $where = [new DataBaseWhere('nick', $operario)];
	    return $this->all($where);
    }

    public function getFichajesByNickIdTarea($operario, $idtarea){
	    $where = [
	    	new DataBaseWhere('nick', $operario),
	    	new DataBaseWhere('idtarea', $idtarea),
	    ];
	    return $this->all($where);
    }

        public function save(): bool
        {
                //Antes de guardar calculamos las horas trabajadas y el total de horas
                $this->calcularDiferencia();
                if (false === parent::save()) {
                        return false;
                }

                $this->updateOperarioTarea();

                $tareaProyecto = new TareaProyecto();
                $tareaProyecto->loadFromCode($this->idtarea);
                $tareaProyecto->save();

                return true;
        }

    private function updateOperarioTarea(): void
    {
            $where = [
                new DataBaseWhere('nick', $this->nick),
                new DataBaseWhere('idtarea', $this->idtarea),
            ];

            $horas = 0.0;
            foreach ((new self())->all($where) as $fichaje) {
                $horas += (float) $fichaje->horas;
            }

            $operarioTareaModel = new OIOperarioTarea();
            $operarioTarea = $operarioTareaModel->all($where);
            $operarioTarea = $operarioTarea[0] ?? new OIOperarioTarea();
            $operarioTarea->nick = $this->nick;
            $operarioTarea->idtarea = $this->idtarea;
            $operarioTarea->horas = $horas;
            $operarioTarea->save();
    }

    private function calcularDiferencia()
    {
	    // Crear objetos DateTime para las fechas de inicio y fin
	    $fechaInicio = new \DateTime($this->inicio);
	    $fechaFin = new \DateTime($this->fin);

	    // Calcular la diferencia
	    $intervalo = $fechaInicio->diff($fechaFin);

	    // Convertir la diferencia a horas y almacenarlo en la variable horas
	    $horasTotales = ($intervalo->d * 24) + $intervalo->h + ($intervalo->i / 60) + ($intervalo->s / 3600);
		$this->horas = number_format($horasTotales, 2, '.', '');

	    $user = new User();
	    $where = [new DataBaseWhere('nick', $this->nick)];
	    $user = $user->all($where)[0];
	    $this->total = $user->coste_hora * $this->horas;
    }

    public function url(string $type = 'auto', string $list = 'List'): string
    {
        return $type === 'list'
            ? 'ListProyecto#ListOiFichajes'
            : parent::url($type, $list);
    }

    public function getTareasHoras(): TareasHoras
    {
        $TareasHoras = new TareasHoras();
	$where = [new DataBaseWhere('idtarea', $this->idtarea)];
	$return = $TareasHoras->all($where)[0];
	if(!$return){
		return new TareasHoras();
	}
	return $return;
    }

}
