<?php
namespace FacturaScripts\Plugins\PartesSemanales\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Tools;

class AvisoParteMaterial extends ModelClass
{
    use ModelTrait;

    /** @var int */
    public $id;

    /** @var int */
    public $idavisoparte;

    /** @var float */
    public $cantidad;

    /** @var string */
    public $descripcion;

    /** @var string */
    public $imagen;

    public function clear()
    {
        parent::clear();
        $this->cantidad = 0;
    }

    public static function primaryColumn(): string
    {
        return 'id';
    }

    public static function tableName(): string
    {
        return 'avisos_partes_materiales';
    }

    public function test(): bool
    {
        $this->descripcion = Tools::noHtml($this->descripcion);
        $this->imagen = Tools::noHtml($this->imagen);
        return parent::test();
    }
}

