<?php
namespace FacturaScripts\Plugins\PartesSemanales\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Tools;

class AvisoParteKilometraje extends ModelClass
{
    use ModelTrait;

    /** @var int */
    public $id;

    /** @var int */
    public $idavisoparte;

    /** @var string */
    public $vehiculo;

    /** @var int */
    public $kminicial;

    /** @var int */
    public $kmfinal;

    /** @var int */
    public $kilometraje;

    public function clear()
    {
        parent::clear();
        $this->kminicial = 0;
        $this->kmfinal = 0;
        $this->kilometraje = 0;
    }

    public static function primaryColumn(): string
    {
        return 'id';
    }

    public static function tableName(): string
    {
        return 'avisos_partes_kilometrajes';
    }

    public function test(): bool
    {
        $this->vehiculo = Tools::noHtml($this->vehiculo);
        return parent::test();
    }
}

