<?php
namespace FacturaScripts\Plugins\PartesSemanales\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Session;
use FacturaScripts\Core\Tools;

class AvisoParteIncidencia extends ModelClass
{
    use ModelTrait;

    /** @var int */
    public $id;

    /** @var int */
    public $idavisoparte;

    /** @var string */
    public $titulo;

    /** @var string */
    public $descripcion;

    /** @var string */
    public $creationdate;

    /** @var string */
    public $nick;

    public function clear()
    {
        parent::clear();
        $this->creationdate = date(self::DATETIME_STYLE);
        $this->nick = Session::get('user')->nick ?? null;
        $this->titulo = '';
    }

    public static function primaryColumn(): string
    {
        return 'id';
    }

    public static function tableName(): string
    {
        return 'avisos_partes_incidencias';
    }

    public function test(): bool
    {
        $this->descripcion = Tools::noHtml($this->descripcion);
        $this->titulo = Tools::noHtml($this->titulo);
        $this->nick = Tools::noHtml($this->nick);
        return parent::test();
    }
}

