<?php
namespace FacturaScripts\Plugins\PartesSemanales\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Session;

class AvisoParteChecklist extends ModelClass
{
    use ModelTrait;

    /** @var int */
    public $id;

    /** @var int */
    public $idavisoparte;

    /** @var string */
    public $descripcion;

    /** @var bool */
    public $marcado;

    /** @var string */
    public $creationdate;

    /** @var string */
    public $nick;

    /** @var string */
    public $lastnick;

    /** @var string */
    public $lastupdate;

    public function clear()
    {
        parent::clear();
        $this->marcado = false;
        $this->creationdate = date(self::DATETIME_STYLE);
        $this->nick = Session::get('user')->nick ?? null;
    }

    public static function primaryColumn(): string
    {
        return 'id';
    }

    public static function tableName(): string
    {
        return 'avisos_partes_checklist';
    }

    public function test(): bool
    {
        $this->lastnick = $this->toolBox()->utils()->noHtml($this->lastnick);
        $this->nick = $this->toolBox()->utils()->noHtml($this->nick);
        return parent::test();
    }

    protected function saveInsert(array $values = []): bool
    {
        $this->lastupdate = null;
        $this->lastnick = null;
        return parent::saveInsert($values);
    }

    protected function saveUpdate(array $values = []): bool
    {
        $this->lastupdate = date(self::DATETIME_STYLE);
        $this->lastnick = Session::get('user')->nick ?? null;
        return parent::saveUpdate($values);
    }
}
