<?php
namespace FacturaScripts\Plugins\PartesSemanales\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Tools;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Plugins\PartesSemanales\Model\AvisoParteChecklist;

class AvisoParte extends ModelClass
{
    use ModelTrait;

    /** @var int */
    public $id;

    /** @var int */
    public $idaviso;

    /** @var float */
    public $horas;

    /** @var float */
    public $horas_extra;

    /** @var int */
    public $comidas;

    /** @var float */
    public $dietas;

    /** @var string */
    public $vehiculo;

    /** @var int */
    public $kilometraje;

    /** @var int */
    public $kminicial;

    /** @var int */
    public $kmfinal;

    /** @var string */
    public $material_pendiente;

    /** @var float */
    public $material_cantidad;

    /** @var string */
    public $material_descripcion;

    /** @var string */
    public $material_imagen;

    /** @var string */
    public $checklist;

    public function clear()
    {
        parent::clear();
        $this->horas = 0;
        $this->horas_extra = 0;
        $this->comidas = 0;
        $this->dietas = 0;
        $this->kilometraje = 0;
        $this->kminicial = 0;
        $this->kmfinal = 0;
        $this->material_cantidad = 0;
        $this->material_descripcion = '';
        $this->material_imagen = '';
    }

    public static function primaryColumn(): string
    {
        return 'id';
    }

    public static function tableName(): string
    {
        return 'avisos_partes';
    }

    public function test(): bool
    {
        $this->vehiculo = Tools::noHtml($this->vehiculo);
        $this->material_pendiente = Tools::noHtml($this->material_pendiente);
        $this->material_descripcion = Tools::noHtml($this->material_descripcion);
        $this->material_imagen = Tools::noHtml($this->material_imagen);
        $this->checklist = Tools::noHtml($this->checklist);
        return parent::test();
    }

    public function getChecklists(): array
    {
        $check = new AvisoParteChecklist();
        return $check->all([new DataBaseWhere('idavisoparte', $this->id)]);
    }
}
