<?php
namespace FacturaScripts\Plugins\PartesSemanales\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Tools;

class Aviso extends ModelClass
{
    use ModelTrait;

    /** @var int */
    public $id;

    /** @var string */
    public $nombre;

    /** @var string */
    public $lugarinstalacion;

    /** @var string */
    public $direccion;

    /** @var string */
    public $poblacion;

    public function clear()
    {
        parent::clear();
    }

    public static function primaryColumn(): string
    {
        return 'id';
    }

    public static function tableName(): string
    {
        return 'avisos';
    }

    public function test(): bool
    {
        $this->nombre = Tools::noHtml($this->nombre);
        $this->lugarinstalacion = Tools::noHtml($this->lugarinstalacion);
        $this->direccion = Tools::noHtml($this->direccion);
        $this->poblacion = Tools::noHtml($this->poblacion);
        return parent::test();
    }

    public function url(string $type = 'auto', string $list = 'List'): string
    {
        if ($type === 'list') {
            return 'ListAviso';
        }
        return parent::url($type, $list);
    }
}
