<?php
namespace FacturaScripts\Plugins\PartesSemanales\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Tools;

class ArchivosTareas extends ModelClass
{
    use ModelTrait;

    /** @var int */
    public $id;

    /** @var int */
    public $id_tarea;

    /** @var string */
    public $path;

    public function clear() 
    {
        parent::clear();
        $this->id_tarea = 0;
    }

    public static function primaryColumn(): string
    {
        return "id";
    }

    public static function tableName(): string
    {
        return "archivos_tareas";
    }

    public function test(): bool
    {
        $this->path = Tools::noHtml($this->path);
        return parent::test();
    }
}
