<?php

namespace FacturaScripts\Plugins\PartesSemanales;

use FacturaScripts\Core\Template\InitClass;
use FacturaScripts\Core\Tools;

class Init extends InitClass
{
    public function init(): void
    {
        // se ejecuta cada vez que carga FacturaScripts (si este plugin está activado).
        $this->loadExtension(new Extension\Controller\EditProyecto());
        $this->loadExtension(new Extension\Controller\ListProyecto());
        $this->loadExtension(new Extension\Controller\EditTareaProyecto());
        $this->loadExtension(new Extension\Model\TareaProyecto());
        $this->loadExtension(new Extension\Controller\ListTareaProyecto());
        $this->loadExtension(new Extension\Model\Proyecto());
    }

    public function uninstall(): void
    {
    }

    public function update(): void
    {
        // valores por defecto de configuración
        $defaults = [
            'vehiculo_kilometraje' => 1,
            'material_pendiente' => 1,
            'checklist' => 1,
            'incidencias' => 1,
            'fichajes' => 1,
            'observaciones' => 1,
            'imagenes' => 1,
            'planos' => 1,
            'partes_vehiculo_kilometraje' => 1,
            'partes_material_pendiente' => 1,
            'partes_planos' => 1,
            'aviso_checklist' => 1,
            'aviso_material_pendiente' => 1,
            'aviso_kilometraje' => 1,
            'aviso_incidencias' => 1,
        ];

        foreach ($defaults as $key => $value) {
            Tools::settings('partessemanales', $key, $value);
        }
        Tools::settingsSave();
    }
}
