<?php
namespace FacturaScripts\Plugins\PartesSemanales\Extension\Controller;

use Closure;
use FacturaScripts\Dinamic\Lib\AssetManager;
use FacturaScripts\Core\Lib\ExtendedController\HtmlView;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Core\Tools;
use FacturaScripts\Dinamic\Model\Proyecto;
use FacturaScripts\Dinamic\Model\OIProyecto;
use FacturaScripts\Dinamic\Model\TareaProyecto;
use FacturaScripts\Plugins\PartesSemanales\Controller\ListOiFichajes;

class ListProyecto
{
	const MODEL_NAMESPACE = '\\FacturaScripts\\Dinamic\\Model\\';

	public function createViews(): Closure
	{
		return function() {

			$this->createviewPlantillas();

			// Añadimos un filtro para ocultar los Proyectos plantilla en la primera pestaña
			$this->addFilterSelectWhere('ListProyecto', 'template', [
					['label' => Tools::lang()->trans('templates'), 'where' => [new DataBaseWhere('plantilla_proyecto', false)]]
			]);

//
            $this->createViewsMaterial();
            $this->createViewsDesplazamientos();
            $this->createViewsHoras();
            $this->createViewsFichajes();
            $this->createViewsIncidencias();
            $this->createViewsPartes();

		};
	}

	protected function addHtmlView(string $viewName=null, string $fileName=null, string $modelName=null, string $viewTitle=null, string $viewIcon = 'fab fa-html5')
	{
		if(!$viewName){
			return;
		}
		$view = new HtmlView($viewName, $viewTitle, self::MODEL_NAMESPACE . $modelName, $fileName, $viewIcon);
		$this->addCustomView($viewName, $view);
	}

    public function createViewsMaterial()
    {
        return function () {
            $viewName = "ListOIMaterialProyecto";
            $this->addView($viewName, 'OIMaterialProyecto', 'Material Pendiente', 'fas fa-tools');

            //Añadimos el buscador
            $this->addSearchFields($viewName, ['referencia', 'descripcion', 'cantidad', 'creationdate', 'lastupdate', 'nick', 'lastnick']);

            //Añadimos la ordenación por defecto
            $this->addOrderBy($viewName, ['creationdate'], 'date', 2);

            //Añadimos un filtro para ocultar los materiales no pendientes
            $this->addFilterSelectWhere($viewName, 'pendiente', [
                ['label' => Tools::lang()->trans('all'), 'where' => []],
                ['label' => Tools::lang()->trans('pending'), 'where' => [new DataBaseWhere('pendiente', true)]],
                ['label' => Tools::lang()->trans('Recibido'), 'where' => [new DataBaseWhere('pendiente', false)]]
            ]);
        };
    }

    public function createViewsDesplazamientos()
    {
        return function () {
            $viewName = "ListOIVehiculoOrden";
            $this->addView($viewName, 'OIVehiculoOrden', 'Desplazamientos', 'fas fa-bus');
        };
    }

    public function createViewsHoras()
    {
        return function () {
            $viewName = "ListOIOperarioTarea";
            $this->addView($viewName, 'OIOperarioTarea', 'Horas', 'fas fa-person-booth')
                ->setSettings('btnNew', false)
                ->setSettings('btnDelete', false);
        };
    }

    public function createViewsFichajes()
    {
        return function () {
            $viewName = "ListOiFichajes";
			$this->addView($viewName, 'OIFichajes', 'Fichajes', 'fas fa-user-clock');

            $this->addSearchFields($viewName, ['inicio', 'fin']);

            // default order, most recent first
            $this->addOrderBy($viewName, ['id'], 'id', 2);

                        $users = $this->codeModel->all('users', 'nick', 'nick');
			$this->addFilterSelect($viewName, 'nick', 'admin', 'nick', $users);

			$ordenes = $this->codeModel->all('tareas', 'nombre', 'nombre');
			$this->addFilterSelect($viewName, 'idtarea', 'tareas', 'idtarea', $ordenes);

			$this->addFilterPeriod($viewName, 'inicio', 'date', 'inicio');

//			$ordenes = $this->codeModel->all('ordenes_instalacion', 'nombre', 'nombre');
//			$this->addFilterSelect($viewName, 'nombre', 'orden', 'nombre', $ordenes);

        };
    }


    public function createViewsIncidencias()
    {
        return function () {
            $viewName = "ListOIncidencia";
            $this->addView($viewName, 'OIncidencia', 'Incidencias', 'fa-solid fa-triangle-exclamation');
        };
    }

    public function createViewsPartes()
    {
        return function () {
            $viewName = "ListPartes";
            $view = $this->addView($viewName, 'Partes', 'Ordenes de Instalación', 'fas fa-home');
        };
    }

	public function execAfterAction(): Closure
	{
		return function($action) {
			// tu código aquí
			// execAfterAction() se ejecuta tras el execAfterAction() del controlador.
		};
	}

	public function execPreviousAction(): Closure
	{
		return function($action) {
			// tu código aquí
			// execPreviousAction() se ejecuta después del execPreviousAction() del controlador.
			// Si devolvemos false detenemos la ejecución del controlador.
		};
	}

	public function loadData(): Closure
	{
		$that = $this; // Capturar el contexto actual de $this

		return function($viewName, $view) use ($that) {
//			if($viewName == "TareasGanttView"){
				$this->gantt = $that->getDataGanttFrappe();

				$this->kanban = $that->getDataKanban();

				$view->loadData();
//			}
		};
	}

	public function getDataKanban()
	{
		$proyectos = (new OIProyecto)->getProyectos();

		$modelKanban = new \FacturaScripts\Dinamic\Model\EstadoProyecto();
		$kanban = $modelKanban->all([], []);

		$model = new \FacturaScripts\Dinamic\Model\Join\TareaProyecto();
		$tareas = $model->all([], []);

		foreach($kanban as $row)
		{
			$estructura[$row->idestado] = [
				"idfase" => $row->idestado,
				"id" => $row->nombre,
				"title" => $row->nombre,
				"class" => "info, good",
				"item" => [],
				"color" => $row->color_estado_proyecto,
			];
		}

		foreach($proyectos as $proyecto){

			$numTareas = 0;

			foreach($tareas as $tarea){
				if($tarea->idproyecto == $proyecto->idproyecto){
					$numTareas++;
				}
			}

			$kanban = &$estructura[$proyecto->idestado];
			$kanban["item"][] = [
				"idtarea" => (string)$proyecto->idproyecto,
				"title" => $proyecto->nombre,
				"descripcion" => $proyecto->descripcion,
				"fecha_limite" => $proyecto->fechafin,
				"idproyecto" => $proyecto->idproyecto,
				"numTareas" => $numTareas
			];
		}

		return $estructura;
	}

	public function convertirFecha($fecha_original=null): string
    {
		$fecha_nueva = date("Y-m-d", strtotime($fecha_original));
		return $fecha_nueva;
	}


	public function getDataGanttFrappe(): array
	{
		return [];
		$modelProyectos = new OIProyecto();
		$proyectos = $modelProyectos->getProyectos();

		$model = new TareaProyecto();
		$tareas = $model->all([], []);

		$id = 0;

		$return = []; 

		foreach ($proyectos as $row) {

			$fecha_inicio = date("Y-m-d", strtotime($row->fechainicio));

			$fecha_fin = date("Y-m-d", strtotime($row->fechafin));

			$idProyecto = "Proyect" . (string)$row->idproyecto;

			$proyecto = [
				"id" => $idProyecto,
				"name" => $row->nombre,
				"start" => $fecha_inicio,
				"end" => $fecha_fin,
			];

			$return[] = $proyecto;

			foreach($tareas as $tarea){

				if(($tarea->idproyecto != $row->idproyecto) || ($tarea->idtareapadre != "")){
					continue;
				}

				if($tarea->fechainicio == "" || $tarea->fechafin == ""){
					continue;
				}

				$idtarea = "Tarea" . $tarea->idtarea;
				$task = [
					"id" => $idtarea,
					"name" => $tarea->nombre,
					"start" => $this->convertirFecha($tarea->fechainicio),
					"end" => $this->convertirFecha($tarea->fechafin),
					"dependencies" => (string)$idProyecto,
				];

				$return[] = $task;


				$modelSubTask = new TareaProyecto();
				$where = [new DataBaseWhere('idtareapadre', $tarea->idtarea)];
				$subTaskRow = $modelSubTask->all($where);

				foreach($subTaskRow as $row){
					$subTask = [
						"id" => "SubTarea" . $idtarea,
						"name" => $row->nombre,
						"start" => $this->convertirFecha($tarea->fechainicio),
						"end" => $this->convertirFecha($tarea->fechafin),
						"dependencies" => $idtarea,
					];
					$return[] = $subTask;
				}

			}

		}
		return $return;
	}

	/*public function actualizarKanban(): void
    {
		if (isset($_POST['idtarea']) && isset($_POST['fase'])) {
			$idTarea = $_POST['idtarea'];
			$fase = $_POST['fase'];
			$idfase = str_replace('group', '', $fase);
			$modelProyectos = new Proyecto();
			if ($modelProyectos->loadFromCode($idTarea)) {
				$modelProyectos->idestado = $idfase;
				$modelProyectos->save();
			}
		}
	}*/

	protected function createviewPlantillas(): Closure
	{
		return function (string $viewName = 'ListProyecto-plantilla') {
			$this->addView($viewName, 'Proyecto', 'templates', 'fas fa-pencil-ruler');

			$this->addFilterSelectWhere($viewName, 'template', [
					['label' => Tools::lang()->trans('templates'), 'where' => [new DataBaseWhere('plantilla_proyecto', true)]]
			]);
		};
	}
	/*protected function createViewGantt(): Closure
	{
		return function () {
			$viewName = "ProyectoGanttFrappeView";
			$view = new HtmlView($viewName, "Gantt", self::MODEL_NAMESPACE . "Join\TareaProyecto", $viewName, 'fas fa-file');
			$this->addCustomView($viewName, $view);
		};
	}*/
	/*protected function createviewKanban(): Closure
	{
		return function () {
			$viewName = "HopeKanbanProyectos";
			$view = new HtmlView($viewName, "Kanban", self::MODEL_NAMESPACE . "Join\TareaProyecto", $viewName, 'fas fa-file');
			$this->addCustomView($viewName, $view);
		};
	}*/


}
