<?php

namespace FacturaScripts\Plugins\PartesSemanales\Extension\Controller;

use Closure;
use FacturaScripts\Core\Tools;
use FacturaScripts\Core\Lib\ExtendedController\HtmlView;
use FacturaScripts\Dinamic\Model\OIOperarioTarea;
use FacturaScripts\Plugins\PartesSemanales\Model\Partes;
use FacturaScripts\Plugins\PartesSemanales\Model\ParteSemanal;
use FacturaScripts\Dinamic\Model\TareaProyecto;
use FacturaScripts\Dinamic\Model\OIProyecto;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Dinamic\Model\AttachedFile;
use FacturaScripts\Core\Model\AttachedFileRelation;
use FacturaScripts\Core\Session;

class EditProyecto
{
    const MODEL_NAMESPACE = '\\FacturaScripts\\Dinamic\\Model\\';


    public function createViews(): Closure
    {
        return function () {
		$this->filterTaskView();

		$this->createViewsMaterial();
		$this->createViewsDesplazamientos();
		$this->createViewsHoras();
		$this->createViewsIncidencias();
                $this->createViewsPartes();
                $this->createViewsPartesSemanales();
                $this->createViewDocFiles();
        };
    }

	public function createViewDocFiles()
	{
		return function () {
			$this->addHtmlView("docfiles", 'Tab/DocFiles', 'AttachedFileRelation', 'Planos', 'fas fa-paperclip');
		};
	}

	public function createViewsMaterial()
	{
		return function () {
			$viewName = "ListOIMaterialProyecto";
			$this->addListView($viewName, 'OIMaterialProyecto', 'Material Pendiente', 'fas fa-tools');
		};
	}

	public function createViewsDesplazamientos()
	{
		return function () {
			$viewName = "ListOIVehiculoOrden";
			$this->addListView($viewName, 'OIVehiculoOrden', 'Desplazamientos', 'fas fa-bus');
		};
	}

        public function createViewsHoras()
        {
                return function () {
                        $viewName = "ListOIOperarioTarea";
                        $this->addListView($viewName, 'OIOperarioTarea', 'Horas', 'fas fa-person-booth');
                };
        }


	public function createViewsIncidencias()
	{
		return function () {
			$viewName = "ListOIncidencia";
			$this->addListView($viewName, 'OIncidencia', 'Incidencias', 'fa-solid fa-triangle-exclamation');
		};
	}

        public function createViewsPartes()
        {
                return function () {
                        $viewName = "ListPartes";
                        $view = $this->addListView($viewName, 'Partes', 'Ordenes de Instalación', 'fas fa-home');
                        $view->setSettings("ListPartes", 'btnNew', false);
                };
        }

        public function createViewsPartesSemanales()
        {
                return function () {
                        $viewName = "ListParteSemanal";
                        $view = $this->addListView($viewName, 'ParteSemanal', 'Partes semanales', 'fas fa-calendar-week');
                        // disable new button to avoid creating weekly parts from projects
                        $view->setSettings("ListParteSemanal", 'btnNew', false);
                        $this->setSettings($viewName, 'btnNew', false);

                        $this->listView($viewName)
                            ->addFilterPeriod('periodo', 'date', 'fechainicio');

                        $projects = $this->codeModel->all('proyectos', 'idproyecto', 'nombre');
                        $this->listView($viewName)
                            ->addFilterSelect('idproyecto', 'Proyecto', 'idproyecto', $projects);
                };
        }

	public function createViewsGanttKanban()
	{
		return function () {
			$viewName = "EditProyectoKanban";
			$view = new HtmlView($viewName, "Gantt & Kanban", self::MODEL_NAMESPACE . "Join\TareaProyecto", $viewName, 'fas fa-project-diagram');

			$viewList = array_slice($this->views, 2); 
			$this->views = array_slice($this->views, 0, 2); 
			// add the settings view to the list of views.
			$this->addCustomView($viewName, $view);
			// restore de list of views. 
			$this->views = $this->views + $viewList; 
		};
	}

    public function execAfterAction(): Closure
    {
        return function ($action) {
            // tu código aquí
            // execAfterAction() se ejecuta tras el execAfterAction() del controlador.
        };
    }

    public function execPreviousAction(): Closure
    {
        return function ($action) {
            if ($action == 'CreatePartes') {
                $this->CreatePartes();
            }
            if ($action == 'add-file') {

		    $uploadFiles = $this->request->files->get('new-files', []);
		    foreach ($uploadFiles as $uploadFile) {
			    if ($uploadFile->move(FS_FOLDER . DIRECTORY_SEPARATOR . 'MyFiles', $uploadFile->getClientOriginalName())) {
				    $newFile = new AttachedFile();
				    $newFile->path = $uploadFile->getClientOriginalName();
				    if (false === $newFile->save()) {
					    Tools::log()->error('fail');
					    return true;
				    }

				    $fileRelation = new AttachedFileRelation();
				    $fileRelation->idfile = $newFile->idfile;
				    $fileRelation->model = $this->getModelClassName();
				    $fileRelation->modelcode = $this->request->query->get('code');
				    $fileRelation->modelid = (int)$fileRelation->modelcode;
				    $fileRelation->nick = $this->user->nick;
				    $fileRelation->observations = $this->request->request->get('observations');
				    $this->pipeFalse('addFileAction', $fileRelation, $this->request);

				    if (false === $fileRelation->save()) {
					    Tools::log()->error('fail-relation');
					    return true;
				    }
			    }
		    }

        // Si se trata de un documento, actualizamos el número de documentos adjuntos.
		    if ($this->getModel() instanceof BusinessDocument) {
			    $this->updateNumDocs();
		    }

		    Tools::log()->notice('record-updated-correctly');
		    return true;

            }

	    if($action == "unlink-file"){
		    if (false === $this->permissions->allowUpdate) {
			    Tools::log()->warning('not-allowed-modify');
			    return true;
		    }

		    $fileRelation = new AttachedFileRelation();
		    $id = $this->request->request->get('id');
		    if ($fileRelation->loadFromCode($id)) {
			    $fileRelation->delete();
		    }

		    Tools::log()->notice('record-updated-correctly');

		    // Si se trata de un documento, actualizamos el número de documentos adjuntos.
		    if ($this->getModel() instanceof BusinessDocument) {
			    $this->updateNumDocs();
		    }

		    return true;

	    }

	    if($action == "delete-file"){
		    if (false === $this->permissions->allowDelete) {
			    Tools::log()->warning('not-allowed-delete');
			    return true;
		    } 			

		    $fileRelation = new AttachedFileRelation();
		    $id = $this->request->request->get('id');
		    if (false === $fileRelation->loadFromCode($id)) {
			    Tools::log()->warning('record-not-found');
			    return true;
		    }

		    if ($fileRelation->modelcode != $this->request->query->get('code') ||
				    $fileRelation->model !== $this->getModelClassName()) {
			    Tools::log()->warning('not-allowed-delete');
			    return true;
		    }

		    $file = $fileRelation->getFile();
		    $fileRelation->delete();
		    $file->delete();

		    Tools::log()->notice('record-deleted-correctly');

		    // Si se trata de un documento, actualizamos el número de documentos adjuntos.
		    if ($this->getModel() instanceof BusinessDocument) {
			    $this->updateNumDocs();
		    }

		    return true;

	    }

	    if($action == "edit-file"){
		    if (false === $this->permissions->allowUpdate) {
			    Tools::log()->warning('not-allowed-modify');
			    return true;
		    } 
		    $fileRelation = new AttachedFileRelation();
		    $id = $this->request->request->get('id');
		    if (false === $fileRelation->loadFromCode($id)) {
			    Tools::log()->warning('record-not-found');
			    return true;
		    }

		    if ($fileRelation->modelcode != $this->request->query->get('code') ||
				    $fileRelation->model !== $this->getModelClassName()) {
			    Tools::log()->warning('not-allowed-modify');
			    return true;
		    }

		    $fileRelation->observations = $this->request->request->get('observations');
		    $this->pipeFalse('editFileAction', $fileRelation, $this->request);

		    if (false === $fileRelation->save()) {
			    Tools::log()->error('record-save-error');
			    return true;
		    }

		    Tools::log()->notice('record-updated-correctly');
		    return true;
	    }
        };
    }

    public function loadData(): Closure
    {
	    $that = $this; // Capturar el contexto actual de $this

	    return function($viewName, $view) use ($that) {

                $id = $this->getViewModelValue('EditProyecto', 'idproyecto');
		$Where = [new DataBaseWhere('idproyecto', $id)];

		switch($viewName){
			case "ListOIVehiculoOrden":
				$ordenes = (new Partes())->all($Where, []);
				$ordenesString = implode(',', array_map(function($orden) {
							return $orden->id;
							}, $ordenes));

				$WhereOrdenes = [new DataBaseWhere('idorden', $ordenesString, "IN")];

				$view->loadData('', $WhereOrdenes);
				break;
			case "ListOIOperarioTarea":
				$WhereTareas = [
					new DataBaseWhere('idproyecto', $id),
					    new DataBaseWhere('idtareapadre', null),
					    new DataBaseWhere('plantillatarea', null),
				];
				$tareas = (new TareaProyecto())->all($WhereTareas, []);

				foreach($tareas as $tarea){
					$WhereTareas = [
						new DataBaseWhere('idtarea', $tarea->idtarea),
					];
					$operarios = (new OIOperarioTarea())->all($WhereTareas, []);
//					$tarea->horastotales = 0;
					foreach($operarios as $operario){
//						$tarea->horastotales += $operario->horas;
					}
					$tarea->save();
				}

				$idTareasString = implode(',', array_map(function($tarea) {
					return $tarea->idtarea;
				}, $tareas));

				$WhereTareas = [new DataBaseWhere('idtarea', $idTareasString, "IN")];

				$view->loadData('', $WhereTareas);
				break;
			case "ListOIncidencia":
				$view->loadData('', $Where);
				break;
                        case "ListPartes":
                                $view->loadData('', $Where);
                                break;
                        case "ListParteSemanal":
                                $view->loadData('', $Where);

                                $unique = [];
                                $filtered = [];
                                $counter = [];

                                usort($view->cursor, function ($a, $b) {
                                        if ($a->idproyecto === $b->idproyecto) {
                                                return strtotime($a->fechainicio) <=> strtotime($b->fechainicio);
                                        }
                                        return $a->idproyecto <=> $b->idproyecto;
                                });

                                foreach ($view->cursor as $model) {
                                        $key = $model->fechainicio . '-' . $model->fechafin . '-' . $model->idproyecto;
                                        if (isset($unique[$key])) {
                                                continue;
                                        }

                                        $project = $model->idproyecto ?: 0;
                                        $counter[$project] = ($counter[$project] ?? 0) + 1;
                                        $model->semana = $model->getSemana($counter[$project]);

                                        $unique[$key] = true;
                                        $filtered[] = $model;
                                }

                                $view->cursor = $filtered;
                                $view->count = count($filtered);
                                break;
                        case "ListOIMaterialProyecto":
                                $view->loadData('', $Where);
                                break;
			case "docfiles":
				$model = $this->getModelClassName();
				$modelid = $this->getModel()->primaryColumnValue();
				$where = [new DataBaseWhere('model', $model)];
				$where[] = is_numeric($modelid) ?
					new DataBaseWhere('modelid|modelcode', $modelid) :
					new DataBaseWhere('modelcode', $modelid);
                $view->loadData('', $where, ['creationdate' => 'DESC']);
                break;
        }

            if ($viewName != 'EditProyecto') {
                return;
            }

            $that->generatePartesSemanales($view->model);

            $this->kanban = (new OIProyecto)->getDataKanban($view->model->idproyecto);
            $this->gantt = (new OIProyecto)->getDataGanttFrappe($view->model->idproyecto);

            // Añadimos boton para el listado de tareas
            $this->addButton('ListTareaProyecto', [
				'type' => 'modal',
                'action' => 'CreatePartes',
                'icon' => 'fas fa-plus-circle',
                'label' => 'Orden Instalacion',
                'color' => 'warning',
			]);

            $this->addButton('ListTareaProyecto', [
				'type' => 'modal',
                'action' => 'NuevaTarea',
                'icon' => 'fas fa-plus-circle',
                'label' => 'Nueva Tarea',
                'color' => 'success',
            ]);

            if ($view->model->plantilla_proyecto == false) {
                return;
            }

            // Es un proyecto y ademas es plantilla
            $this->addButton($viewName, [
                'action' => 'CopyProyecto?code=' . $view->model->idproyecto,
                'icon' => 'fas fa-copy',
                'label' => 'Copiar',
                'color' => 'warning',
                'type' => 'link'
            ]);
        };
    }


    public function CreatePartes(): Closure
    {
        return function () {
            // nos traemos los codigos
            $codes = $this->request->request->get('code', []);
            $date = $this->request->request->get('date', []);
            $idorden = $this->request->request->get('id', []);
            $nombre = $this->request->request->get('nombre', []);

            if (empty($codes)) {
                Tools::log()->error('No se ha seleccionado nada');
                return;
            }

	    $codes = explode(",", $codes);

	    $exist = false;

            foreach ($codes as $code) {
                $tarea = new TareaProyecto();
                $tarea->loadFromCode($code);
		if(!$tarea->idorden){
			$exist = true;
		}
            }

	    if(!$exist){
                Tools::log()->error('Todas las tareas seleccionadas estan asignadas a una orden de instalacion');
		return;
	    }

            // creamos la orden de instalacion
            $orden = new Partes();

	    if($idorden){
		    $orden->loadFromCode($idorden);
	    }else{
		    if($date){
			    $orden->creationdate = $date;
		    }
		    $orden->lastupdate = $orden->creationdate;
		    $orden->idproyecto = $this->request->query->get('code');
		    $orden->nombre = $nombre;
		    $orden->save();
	    }


        // Leemos las tareas a partir de los codes y le asignamos el idorden
        foreach ($codes as $code) {
            $tarea = new TareaProyecto();
            $tarea->loadFromCode($code);
		if(!$tarea->idorden){
			$tarea->idorden = $orden->id;
			$tarea->save();
		}
            }

        };
    }

    public function filterTaskView()
    {
            return function () {
                    $this->views["ListTareaProyecto"]->addFilterSelectWhere('template', [
                                    ['label' => Tools::lang()->trans('templates'), 'where' => [
                                        new DataBaseWhere('idtareapadre', null, '='),
                                        new DataBaseWhere('plantillatarea', null, "="),
                                        ]
                                ]
                    ]);
            };
    }

    public function generatePartesSemanales($proyecto=null): void
	{
		if(!$proyecto){
			return;
		}
        if (empty($proyecto->fechainicio) || empty($proyecto->fechafin)) {
            return;
        }

        $inicio = new \DateTime($proyecto->fechainicio);
        $finProyecto = new \DateTime($proyecto->fechafin);

        while ($inicio <= $finProyecto) {
            $finSemana = clone $inicio;
            $finSemana->modify('+6 days');
            if ($finSemana > $finProyecto) {
                $finSemana = clone $finProyecto;
            }

            $parte = new ParteSemanal();
            $where = [
                new DataBaseWhere('idproyecto', $proyecto->idproyecto),
                new DataBaseWhere('fechainicio', $inicio->format('Y-m-d'))
            ];

            if (false === $parte->loadFromCode('', $where)) {
                $parte->idproyecto = $proyecto->idproyecto;
                $parte->fechainicio = $inicio->format('Y-m-d');
                $parte->fechafin = $finSemana->format('Y-m-d');
                $parte->nick = $this->user->nick ?? Session::get('user')->nick ?? '';
                $parte->save();
            } elseif (empty($parte->fechafin)) {
                $parte->fechafin = $finSemana->format('Y-m-d');
                $parte->save();
            }

            $inicio->modify('+1 week');
        }
    }

}
