<?php declare(strict_types=1);

namespace FacturaScripts\Plugins\PartesSemanales\Controller;

use FacturaScripts\Core\Lib\ExtendedController\ListController;

/**
 * Este es un controlador específico para listados. Permite una o varias pestañas.
 * Cada una con un listado de los registros de un modelo.
 * Además hace uso de archivos de XMLView para definir qué columnas mostrar y cómo.
 *
 * https://facturascripts.com/publicaciones/listcontroller-232
 */
class ListTipoTarea extends ListController
{
    public function getPageData(): array
    {
        $pageData = parent::getPageData();
        $pageData["title"] = "Tipo de tarea";
        $pageData["menu"] = "";
        $pageData["icon"] = "fas fa-search";
        return $pageData;
    }

    protected function createViews(): void
    {
        $this->createViewsTipoTarea();
    }

    protected function createViewsTipoTarea(string $viewName = "ListTipoTarea"): void
    {
        $this->addView($viewName, "TipoTarea", "Tipo de tarea");
        
        // Esto es un ejemplo ... debe de cambiarlo según los nombres de campos del modelo
        // $this->addOrderBy($viewName, ["id"], "id", 2);
        // $this->addOrderBy($viewName, ["name"], "name");
        
        // Esto es un ejemplo ... debe de cambiarlo según los nombres de campos del modelo
        // $this->addSearchFields($viewName, ["id", "name"]);
    }
}
