<?php

namespace FacturaScripts\Plugins\PartesSemanales\Controller;

use FacturaScripts\Core\Lib\ExtendedController\ListController;

class ListParteSemanal extends ListController
{
    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data['title'] = 'Partes Semanales';
        $data['icon'] = 'fas fa-calendar-week';
		$data['menu'] = 'projects';
        return $data;
    }

    protected function createViews(): void
    {
        $viewName = 'ListParteSemanal';
        $this->addView($viewName, 'ParteSemanal', 'Partes Semanales');
        $this->setSettings($viewName, 'btnNew', false);

        // filters
        $this->addFilterPeriod($viewName, 'periodo', 'date', 'fechainicio');

        $projects = $this->codeModel->all('proyectos', 'idproyecto', 'nombre');
        $this->addFilterSelect($viewName, 'idproyecto', 'Proyecto', 'idproyecto', $projects);
    }

    protected function loadData($viewName, $view)
    {
        parent::loadData($viewName, $view);

        if ($viewName === 'ListParteSemanal') {
            $unique = [];
            $filtered = [];
            $counter = [];

            usort($view->cursor, function ($a, $b) {
                if ($a->idproyecto === $b->idproyecto) {
                    return strtotime($a->fechainicio) <=> strtotime($b->fechainicio);
                }
                return $a->idproyecto <=> $b->idproyecto;
            });

            foreach ($view->cursor as $model) {
                $key = $model->fechainicio . '-' . $model->fechafin . '-' . $model->idproyecto;
                if (isset($unique[$key])) {
                    continue;
                }

                $project = $model->idproyecto ?: 0;
                $counter[$project] = ($counter[$project] ?? 0) + 1;
                $model->semana = $model->getSemana($counter[$project]);

                $unique[$key] = true;
                $filtered[] = $model;
            }

            $view->cursor = $filtered;
            $view->count = count($filtered);
        }
    }
}
