<?php

namespace FacturaScripts\Plugins\PartesSemanales\Controller;

use FacturaScripts\Core\Lib\ExtendedController\ListController;

class ListOiVehiculo extends ListController
{
    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data["title"] = "Gestion de Flota";
        $data["menu"] = "warehouse";
        $data["icon"] = "fas fa-car";
        return $data;
    }

    protected function createViews()
    {
        $this->createViewsOiFlota();
    }

    protected function createViewsOiFlota(string $viewName = "ListOiVehiculo")
    {
        $this->addView($viewName, "OiVehiculo", "Flota");

        $this->addView('ListOiVehiculo', 'OiVehiculo', 'Flota', 'fas fa-car');
        $this->addSearchFields('ListOiVehiculo', ['matricula', 'modelo_vehiculo']);
        $this->addOrderBy('ListOiVehiculo', ['matricula'], 'Matricula');
        $this->addOrderBy('ListOiVehiculo', ['modelo_vehiculo'], 'Modelo');
    }
}
