<?php

namespace FacturaScripts\Plugins\PartesSemanales\Controller;

use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Core\Lib\ExtendedController\ListController;
use FacturaScripts\Core\Tools;

class ListOIMaterialProyecto extends ListController
{
    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data["title"] = "Material Pendiente";
        $data["showonmenu"] = false;
        $data["icon"] = "fas fa-building";
        return $data;
    }

    protected function createViews()
    {
        $this->createViewsOIMaterialProyecto();
    }

    protected function createViewsOIMaterialProyecto(string $viewName = "ListOIMaterialProyecto"): void
    {
        $this->addView($viewName, "OIMaterialProyecto", "Material Pendiente");
        $this->addOrderBy($viewName, ["creationdate"], "date", 2);
        $this->addSearchFields($viewName, ["referencia", "descripcion", "cantidad", "creationdate", "lastupdate", "nick", "lastnick"]);
        $this->addFilterSelectWhere($viewName, 'pendiente', [
            ['label' => Tools::lang()->trans('all'), 'where' => []],
            ['label' => Tools::lang()->trans('pending'), 'where' => [new DataBaseWhere('pendiente', true)]],
            ['label' => Tools::lang()->trans('Recibido'), 'where' => [new DataBaseWhere('pendiente', false)]]
        ]);
    }
}
