<?php declare(strict_types=1);

namespace FacturaScripts\Plugins\PartesSemanales\Controller;

use FacturaScripts\Core\Lib\ExtendedController\ListController;

class ListChecklist extends ListController
{
    public function getPageData(): array
    {
        $pageData = parent::getPageData();
        $pageData['title'] = 'Checklist';
        $pageData['menu'] = 'projects';
        $pageData['icon'] = 'fas fa-clipboard-check';
        return $pageData;
    }

    protected function createViews(): void
    {
        $this->createViewsChecklist();
    }

    protected function createViewsChecklist(string $viewName = 'ListChecklist'): void
    {
        $this->addView($viewName, 'AvisoParteChecklist', 'Checklist');
    }
}
