<?php declare(strict_types=1);

namespace FacturaScripts\Plugins\PartesSemanales\Controller;

use FacturaScripts\Core\Lib\ExtendedController\ListController;

class ListAviso extends ListController
{
    public function getPageData(): array
    {
        $pageData = parent::getPageData();
        $pageData['title'] = 'Avisos';
        $pageData['menu'] = 'projects';
        $pageData['icon'] = 'fas fa-bullhorn';
        return $pageData;
    }

    protected function createViews(): void
    {
        $this->createViewsAviso();
    }

    protected function createViewsAviso(string $viewName = 'ListAviso'): void
    {
        $this->addView($viewName, 'Aviso', 'Avisos');

        // $this->addOrderBy($viewName, ['id'], 'id', 2);
        // $this->addOrderBy($viewName, ['nombre'], 'name');

        // $this->addSearchFields($viewName, ['id', 'nombre']);
    }
}
