<?php

namespace FacturaScripts\Plugins\PartesSemanales\Controller;

use FacturaScripts\Core\Lib\ExtendedController\EditController;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;

class EditTareasHoras extends EditController
{

    public function getModelClassName(): string
    {
        return "TareasHoras";
    }

    protected function createViews()
    {
        parent::createViews();
        $mainView = $this->getMainViewName();
        $this->views[$mainView]->setReadOnly(true);
        $this->setSettings($mainView, 'btnDelete', false);
        $this->setSettings($mainView, 'btnNew', false);
        $this->setSettings($mainView, 'btnSave', false);

        $this->setTabsPosition("left-bottom");
        $this->createViewsHoras();
    }

    protected function createViewsHoras(string $viewName = "ListHorasTarea")
    {
        $this->addListView($viewName, "OIFichajes", "Horas");
        $this->setSettings($viewName, 'btnDelete', false);
        $this->setSettings($viewName, 'btnEdit', false);
        $this->setSettings($viewName, 'btnNew', false);
        $this->setSettings($viewName, 'clickable', false);
    }

    protected function loadData($viewName, $view)
    {
	    if ($viewName == 'ListHorasTarea') {
		    $idtarea = $this->request->get('code');
		    $Where = [new DataBaseWhere('idtarea', $idtarea)];
		    $view->loadData('', $Where);
		    return;
	    }

	    parent::loadData($viewName, $view);
    }


}
