<?php

namespace FacturaScripts\Plugins\PartesSemanales\Controller;
use Closure;
use FacturaScripts\Core\Base\Controller;
use FacturaScripts\Core\KernelException;
use FacturaScripts\Dinamic\Model\CodeModel;
use FacturaScripts\Dinamic\Model\Proyecto;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Dinamic\Model\AttachedFile;
use FacturaScripts\Plugins\PartesSemanales\Model\OIMaterialProyecto;
use FacturaScripts\Plugins\PartesSemanales\Model\OIncidencia;
use FacturaScripts\Plugins\PartesSemanales\Model\OIVehiculoOrden;
use FacturaScripts\Plugins\PartesSemanales\Model\OIFichajes;
use FacturaScripts\Plugins\PartesSemanales\Model\Partes;
use FacturaScripts\Core\Lib\ExtendedController\EditController;
use FacturaScripts\Dinamic\Model\UsuariosNotificaciones;
use FacturaScripts\Core\Session;
use FacturaScripts\Core\Tools;

use FacturaScripts\Dinamic\Controller\EditTareaProyecto;

class EditPartes extends Controller
{
    public $codeModel;
    public $orden;

    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data["title"] = "Partes";
        $data["icon"] = "fas fa-home";
	    $data['menu'] = "";
        return $data;
    }

    public function createViews(): Closure
    {
        return function () {
            $this->createviewsVehiculos();
            $this->createviewsHorasTrajajo();
            $this->createviewsIncicencias();

        };
    }

    protected function createviewsVehiculos(string $viewName = 'EditOIVehiculoOrden'): void
    {
        $this->addView($viewName, 'OIVehiculoOrden', 'vehiculos', 'fas fa-car');
    }


    protected function createviewsHorasTrajajo(string $viewName = 'EditOIOperarioTarea'): void
    {
            $this->addListView($viewName, 'OIOperarioTarea', 'operarios', 'fas fa-user');
    }

    protected function createviewsIncicencias(string $viewName = 'EditOIncidencia'): void
    {
            $this->addListView($viewName, 'OIncidencia', 'incidencias', 'fas fa-exclamation-triangle');
    }

    /**
     * @throws KernelExceptio
     */
    public function privateCore(&$response, $user, $permissions): void
	{
        parent::privateCore($response, $user, $permissions);

        $this->codeModel = new CodeModel();
        $this->orden = new Partes();
        $this->orden->loadFromCode($this->request->get('code'));

		$tarea = new EditTareaProyecto("");
		$tarea->loadData("EditTareaProyecto", "", true);

		$this->tarea = $tarea;


        $action = $this->request->get('action');

        switch ($action) {
            case 'guardarFichaje':
                if (Tools::settings('partessemanales', 'partes_fichaje')) {
                    $this->guardarFichaje();
                }
                break;
            case 'guardarKilometraje':
                if (Tools::settings('partessemanales', 'vehiculo_kilometraje')
                    && Tools::settings('partessemanales', 'partes_vehiculo_kilometraje')) {
                    $this->guardarKilometraje();
                }
                break;
            case 'actualizarKilometraje':
                if (Tools::settings('partessemanales', 'vehiculo_kilometraje')
                    && Tools::settings('partessemanales', 'partes_vehiculo_kilometraje')) {
                    $this->actualizarKilometraje();
                }
                break;
            case 'eliminarKilometraje':
                if (Tools::settings('partessemanales', 'vehiculo_kilometraje')
                    && Tools::settings('partessemanales', 'partes_vehiculo_kilometraje')) {
                    $this->eliminarKilometraje();
                }
                break;
            case 'guardarTarea':
                $this->guardarTarea();
                break;
            case 'guardarMaterialPte':
                if (Tools::settings('partessemanales', 'material_pendiente')
                    && Tools::settings('partessemanales', 'partes_material_pendiente')) {
                    $this->guardarMaterialPte();
                }
                break;
            case 'guardarIncidencia':
                if (Tools::settings('partessemanales', 'incidencias')) {
                    $this->guardarIncidencia();
                }
                break;
            case 'actualizarMaterial':
                if (Tools::settings('partessemanales', 'material_pendiente')
                    && Tools::settings('partessemanales', 'partes_material_pendiente')) {
                    $this->actualizarMaterial();
                }
                break;
            case 'eliminarMaterial':
                if (Tools::settings('partessemanales', 'material_pendiente')
                    && Tools::settings('partessemanales', 'partes_material_pendiente')) {
                    $this->eliminarMaterial();
                }
                break;
            case 'guardarEstado':
                $this->guardarEstado();
                break;
            case 'nuevoChecklist':
                if (Tools::settings('partessemanales', 'partes_checklist')) {
                    $this->nuevoChecklist();
                }
                break;
            case 'guardarImagenMaterial':
                if (Tools::settings('partessemanales', 'material_pendiente')
                    && Tools::settings('partessemanales', 'partes_material_pendiente')) {
                    $this->guardarImagenMaterial();
                }
                break;

		case "actualizarTarea":
//			$this->orden->actualizarTarea();
		break;
	
        }
    }

	public function guardarImagenTarea(){
		if(isset($_FILES['files']) && count($_FILES['files']) > 0){
			$this->orden->guardarImagenTarea($_FILES['files'], $_POST['idtarea']);
		}
	}

	public function guardarImagenMaterial(){
		if(isset($_FILES['files']) && count($_FILES['files']) > 0){
			$this->orden->guardarImagenMaterial($_FILES['files'], $_POST['idMaterial']);
		}
	}

	private function guardarTarea()
	{
		$task = new \FacturaScripts\Dinamic\Model\TareaProyecto();
		$where = [
			new DataBaseWhere('idtarea', $_POST['idtarea']),
		];
		$task = $task->all($where)[0];

		$subTask = new \FacturaScripts\Dinamic\Model\TareaProyecto();
		$where = [
			new DataBaseWhere('idtareapadre', $_POST['idtarea']),
		];
		$subtasks = $subTask->all($where);

		$_POST['descripcionTarea'] = $task->descripcion;
		$_POST['idfase'] = $_POST['idfase_fase'];
		$_POST['fechainicio'] = $_POST['fecha_inicio_tarea'];
		$_POST['fechafin'] = $_POST['fecha_fin_tarea'];
		$_POST['idtarea'] = $task->idtarea;
		$_POST['responsable'][] = $task->responsable;
//		$_POST['horaInicio'] = $_POST['hora_inicio_tarea_' . $task->idtarea ];
//		$_POST['horaFin'] = $_POST['hora_fin_tarea_' . $task->idtarea ];
		$_POST['update_task'] = true;
		$_POST['comentarios'] = $_POST['observaciones'];

		$operarioTarea = new \FacturaScripts\Dinamic\Model\OIOperarioTarea();
		$where = [new DataBaseWhere('idtarea', $task->idtarea)];
		$operariosModel = $operarioTarea->all($where);

		foreach($operariosModel as $operario){
			$_POST['operarios'][] = $operario->nick;
		}

		//subtarea
		foreach($subtasks as $subTask){

			$subtaskId = $subTask->idtarea;

			$checkbox = "checkbox_subtarea_";

			if (isset($_POST[$checkbox . $subtaskId]) && $_POST[$checkbox . $subtaskId] == "on") {
				$checked = true;
			} else {
				$checked = false;
			}

			$_POST["checklist"][0][] = [
				"marcado" => $checked,
				"descripcion" => $subTask->nombre,
				"id" => $subTask->idtarea

			];
		
			$existeSubatarea = "subtarea_" . $subtaskId;

			$existe = false;
			foreach ($_POST as $clave => $valor) {
				if (strpos($clave, $existeSubatarea) !== false) {
					$existe = true;
					break; // Si encontramos una coincidencia, podemos salir del bucle
				}
			}

			if(!$existe){
				continue;
			}

			$operarios = $_POST['operario_subtarea_' . $subTask->idtarea];

			if($operarios == "-1"){
				$operarios = "";
			}

			if(isset($_POST['comentariosSubtarea_'.$subTask->idtarea])){
				$comentariosSubtarea = $_POST['comentariosSubtarea_'.$subTask->idtarea];
			}else{
				$comentariosSubtarea = "";
			}

			if (!isset($subTask->imagenes)) {
				$subTask->imagenes = array();
			}

			if (!isset($subTask->idsubtarea)) {
				$subTask->idsubtarea = null;
			}

			$_POST['subTareas'][] = [
				'cantidad' => $subTask->cantidad,
				'descripcion' => $subTask->descripcion,
				'fecha' => $subTask->fecha,
				'fechafin' => $subTask->fechafin,
				'fechainicio' => $subTask->fechainicio,
				'idfase' => $subTask->idfase,
				'idproyecto' => $subTask->idproyecto,
				'idtarea' => $subTask->idtarea,
				'nombre' => $subTask->nombre,
				'hora_fin' => $_POST['hora_inicio_subtarea_' . $subTask->idtarea],
				'hora_inicio' => $_POST['hora_fin_subtarea_' . $subTask->idtarea],
				'idsubtarea' => $subTask->idsubtarea,
				'imagenes' => $subTask->imagenes,
				'operarios' => $operarios,
				'plantillatarea' => $subTask->plantillatarea,
				'responsable' => $subTask->responsable,
				'idtareapadre' => $subTask->idtareapadre,
				'checked' => $checked,
				'idorden' => $subTask->idorden,
				'comentarios' => $comentariosSubtarea
			];

		}

		$this->orden->actualizarTarea();

		if(isset($_FILES['archivos']) && count($_FILES['archivos']) > 0){
			$this->orden->guardarImagenTarea($_FILES['archivos'], $_POST['idtarea']);
		}
	}


	private function guardarFichaje(): void
	{
		// Obtener el usuario de la sesión
		$nick = Session::get('user')->nick;

		// Obtener datos del request
		$idtarea = $this->request->get('idtarea');
		$tipoFichaje = $this->request->get('tipo_fichaje');

		// Crear una nueva instancia del modelo OIFichajes
		$fichajes = new OIFichajes();

		if ($tipoFichaje === 'entrada') {
			// Crear un nuevo registro para la entrada
			$fichajes->inicio = date('Y-m-d H:i:s'); // Fecha y hora actual
			$fichajes->fin = null; // La salida aún no está registrada
			$fichajes->idtarea = $idtarea;
			$fichajes->nick = $nick;

			// Guardar el registro
			$fichajes->save();
		} elseif ($tipoFichaje === 'salida') {
			// Configurar los filtros para buscar fichajes pendientes de salida
			$where = [
				new DataBaseWhere('idtarea', $idtarea),
				new DataBaseWhere('nick', $nick),
				new DataBaseWhere('fin', null, '=', 'AND') // Fichajes sin salida
			];

			// Buscar el registro
			$fichajePendiente = $fichajes->all($where);

			if (!empty($fichajePendiente)) {
				// Actualizar el último fichaje pendiente de salida
				$fichaje = $fichajePendiente[0]; // Usamos el primero encontrado
				$fichaje->fin = date('Y-m-d H:i:s');

				// Calcular horas trabajadas
				$inicio = strtotime($fichaje->inicio);
				$fin = strtotime($fichaje->fin);
				$fichaje->horas = round(($fin - $inicio) / 3600, 2);
				$fichaje->save();

			} else {

				// Manejar error: No se encontró un fichaje pendiente de salida

			}
		} else {
			// Manejar error: Tipo de fichaje inválido

		}
	}




    private function guardarKilometraje(): void
    {
        $vehiculoOrden = new OIVehiculoOrden();
        $vehiculoOrden->idorden = $this->orden->id;
        $vehiculoOrden->idvehiculo = $this->request->get('idvehiculo');
        $vehiculoOrden->km_ini = $this->request->get('kminicial');
        $kmfinal = $this->request->get('kmfinal');
        $vehiculoOrden->km_fin = ($kmfinal === '' || $kmfinal === null) ? null : (float) $kmfinal;
        $vehiculoOrden->save();
    }

    private function actualizarKilometraje(): void
    {
        $vehiculoOrden = new OIVehiculoOrden();
        $vehiculoOrden->loadFromCode($this->request->get('id'));
        $vehiculoOrden->km_ini = $this->request->get('kminicial');
        $kmfinal = $this->request->get('kmfinal');
        $vehiculoOrden->km_fin = ($kmfinal === '' || $kmfinal === null) ? null : (float) $kmfinal;
        $vehiculoOrden->idvehiculo = $this->request->get('idvehiculo');
        $vehiculoOrden->save();
    }

    private function eliminarKilometraje(): void
    {
        $vehiculoOrden = new OIVehiculoOrden();
        $vehiculoOrden->loadFromCode($this->request->get('id'));
        $vehiculoOrden->delete();
    }


    // Nos guardamos el material pendiente
    private function guardarMaterialPte(): void
    {
        $materialPte = new OIMaterialProyecto();
        $materialPte->idorden = $this->orden->id;
        $materialPte->idproyecto = $this->orden->idproyecto;
        $materialPte->id = $this->request->get('id');
        $materialPte->descripcion = $this->request->get('descripcion');
        $materialPte->cantidad = $this->request->get('cantidad');
        $materialPte->pendiente = $this->request->get('pendiente');
		$materialPte->save();

		if(isset($_FILES['imagenesIncidencia']) && count($_FILES['imagenesIncidencia']) > 0){
			$this->orden->guardarImagenMaterial($_FILES['imagenesIncidencia'], $materialPte->id);
		}

		$notificaciones = new UsuariosNotificaciones();
		$notificaciones->send(UsuariosNotificaciones::NUEVO_MATERIAL_PENDIENTE, $materialPte);
    }


    // acualizamos el material pendiente
    private function actualizarMaterial(): void
    {
        $materialPte = new OIMaterialProyecto();
        $materialPte->loadFromCode($this->request->get('id'));
        $materialPte->descripcion = $this->request->get('descripcion');
        $materialPte->cantidad = $this->request->get('cantidad');
        $materialPte->save();

        $imagenesBorradas = $this->request->get('imagenesBorradas');
        if ($imagenesBorradas) {
            $urls = explode(',', $imagenesBorradas);
            foreach ($urls as $url) {
                $urlParts = explode('?myft=', $url);
                $path = $urlParts[0];

                $adjunto = new AttachedFile();
                $where = [new DataBaseWhere('path', $path)];
                foreach ($adjunto->all($where) as $archivo) {
                    $archivo->delete();
                }
            }
        }
    }

    // eliminamos el material pendiente
    private function eliminarMaterial(): void
    {
        $materialPte = new OIMaterialProyecto();
        $materialPte->loadFromCode($this->request->get('id'));
        $materialPte->delete();
    }

    // Nos guardamos la incidencia
    public function guardarIncidencia(): void
    {
	    if(isset($_REQUEST['action']) && $_REQUEST['action'] == "guardarIncidencia"){
		    $ordenInstalacion = new Partes();
		    $ordenInstalacion->guardarIncidencia($_FILES['files'], $_REQUEST);
	    }
    }

    public function guardarEstado(): void
	{
	    if(isset($_REQUEST['action']) && $_REQUEST['action'] == "guardarEstado"){
		    $ordenInstalacion = new Partes();
		    $ordenInstalacion->loadFromCode($_REQUEST['idorden']);
		    $ordenInstalacion->estado = $_REQUEST['estadoPartes'];

		    $today = date("Y-m-d");

		switch($ordenInstalacion->estado){
			case "Pendiente":
				break;
			case "Abierta":
				$ordenInstalacion->fechaapertura = $today;
				break;
			case "Cerrada":
				$ordenInstalacion->fechacierre = $today;
				break;
			default:
				break;

		}

		    $ordenInstalacion->save();
	    }
	}

    public function nuevoChecklist(): void 
    {
	    if(isset($_REQUEST['action']) && $_REQUEST['action'] == "nuevoChecklist"){
		    $modelSubTask = new \FacturaScripts\Dinamic\Model\TareaProyecto();
		    $modelSubTask->idtareapadre = $_REQUEST['idtareapadre'];
		    $modelSubTask->idproyecto = $_REQUEST['idproyecto'];
		    $modelSubTask->nombre = $_REQUEST['checklistTitulo'];
		    $modelSubTask->checked = false;
		    $modelSubTask->cantidad = 0;
		    $modelSubTask->idfase = 1;
		    $modelSubTask->save();

	    }
    }



}
