<?php

namespace FacturaScripts\Plugins\PartesSemanales\Controller;

use FacturaScripts\Core\Lib\ExtendedController\EditController;
use FacturaScripts\Core\Base\Controller;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Plugins\PartesSemanales\Model\ParteSemanal;
use FacturaScripts\Plugins\PartesSemanales\Model\ParteSemanalDia;
use FacturaScripts\Plugins\PartesSemanales\Model\OIVehiculoOrden;
use FacturaScripts\Plugins\PartesSemanales\Model\OIMaterialProyecto;
use FacturaScripts\Plugins\PartesSemanales\Model\OIChecklistDia;
use FacturaScripts\Plugins\PartesSemanales\Model\Partes;
use FacturaScripts\Dinamic\Model\CodeModel;
use FacturaScripts\Core\Session;
use FacturaScripts\Core\Base\Calculator;
use FacturaScripts\Core\Tools;

class EditParteSemanal extends Controller
{
    public $codeModel;
    public $orden;
    public $dias = [];

    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data["title"] = "Partes Semanal";
        $data["icon"] = "fas fa-home";
	    $data['menu'] = "";
        return $data;
	}

    public function getModelClassName(): string
    {
        return 'ParteSemanal';
    }

    protected function createViews(): void
    {
        parent::createViews();
        $this->addListView('ListParteSemanalDia', 'ParteSemanalDia', 'Dias', 'fas fa-calendar-day');
    }

    public function privateCore(&$response, $user, $permissions): void
    {
        parent::privateCore($response, $user, $permissions);

        $this->codeModel = new CodeModel();

        $this->orden = new ParteSemanal();
        $this->orden->loadFromCode($this->request->get('code'));

        if ($this->orden->id) {
			$action = $this->request->get('action');
            switch ($action) {
                case 'saveDia':
                    $this->guardarDia();
                    break;
                case 'guardarKilometraje':
                    if (Tools::settings('partessemanales', 'vehiculo_kilometraje')) {
                        $this->guardarKilometraje();
                    }
                    break;
                case 'actualizarKilometraje':
                    if (Tools::settings('partessemanales', 'vehiculo_kilometraje')) {
                        $this->actualizarKilometraje();
                    }
                    break;
                case 'eliminarKilometraje':
                    if (Tools::settings('partessemanales', 'vehiculo_kilometraje')) {
                        $this->eliminarKilometraje();
                    }
                    break;
                case 'guardarMaterialPte':
                    if (Tools::settings('partessemanales', 'material_pendiente')) {
                        $this->guardarMaterialPte();
                    }
                    break;
                case 'guardarIncidencia':
                    $this->guardarIncidencia();
                    break;
                case 'actualizarMaterial':
                    if (Tools::settings('partessemanales', 'material_pendiente')) {
                        $this->actualizarMaterial();
                    }
                    break;
                case 'eliminarMaterial':
                    if (Tools::settings('partessemanales', 'material_pendiente')) {
                        $this->eliminarMaterial();
                    }
                    break;
                case 'nuevoChecklistDia':
                    if (Tools::settings('partessemanales', 'checklist')) {
                        $this->nuevoChecklistDia();
                    }
                    break;
                case 'guardarChecklistDia':
                    if (Tools::settings('partessemanales', 'checklist')) {
                        $this->guardarChecklistDia();
                    }
                    break;
                case 'eliminarChecklistDia':
                    if (Tools::settings('partessemanales', 'checklist')) {
                        $this->eliminarChecklistDia();
                    }
                    break;
                case 'crearAlbaran':
                    $this->crearAlbaran();
                    break;
            }

            $diaModel = new ParteSemanalDia();
            $user = Session::get('user');
            $userNick = $user->nick ?? null;
            $where = [new DataBaseWhere('idparte', $this->orden->id)];

            // Los usuarios con nivel bajo solo pueden ver sus propios días
            if (($user->level ?? 0) <= 90) {
                $where[] = new DataBaseWhere('nick', $userNick);
            }

            if (0 === $diaModel->count($where)) {
                for ($i = 1; $i <= 5; ++$i) {
                    $nuevo = new ParteSemanalDia();
                    $nuevo->idparte = $this->orden->id;
                    $nuevo->dia = $i;
                    $nuevo->nick = $userNick;
                    $nuevo->save();
                }
            }

			$this->dias = $diaModel->all($where, ['dia' => 'ASC']);
        }
    }

    private function guardarDia(): void
    {
        $dia = new ParteSemanalDia();
        $dia->loadFromCode($this->request->request->get('id'));
        if ($dia->nick !== (Session::get('user')->nick ?? null)) {
            return;
        }
        $dia->horas = (float) $this->request->request->get('horas');
        $dia->horas_extra = (float) $this->request->request->get('horas_extra');
        $dia->comidas = (int) $this->request->request->get('comidas');
        $dia->dietas = (float) $this->request->request->get('dietas');
        $dia->save();
    }

    private function guardarKilometraje(): void
    {
        $vehiculoOrden = new OIVehiculoOrden();
        $vehiculoOrden->idparte_dia = $this->request->get('iddiaseleccion');
        $vehiculoOrden->idvehiculo = $this->request->get('idvehiculo');
        $vehiculoOrden->km_ini = $this->request->get('kminicial');
        $kmfinal = $this->request->get('kmfinal');
        $vehiculoOrden->km_fin = ($kmfinal === '' || $kmfinal === null) ? null : (float) $kmfinal;
        $vehiculoOrden->save();
    }

    private function actualizarKilometraje(): void
    {
        $vehiculoOrden = new OIVehiculoOrden();
        $vehiculoOrden->loadFromCode($this->request->get('id'));
        if ($vehiculoOrden->nick !== (Session::get('user')->nick ?? null)) {
            return;
        }
        $vehiculoOrden->idvehiculo = $this->request->get('idvehiculo');
        $vehiculoOrden->km_ini = $this->request->get('kminicial');
        $kmfinal = $this->request->get('kmfinal');
        $vehiculoOrden->km_fin = ($kmfinal === '' || $kmfinal === null) ? null : (float) $kmfinal;
        $vehiculoOrden->save();
    }

    private function eliminarKilometraje(): void
    {
        $vehiculoOrden = new OIVehiculoOrden();
        $vehiculoOrden->loadFromCode($this->request->get('id'));
        if ($vehiculoOrden->nick !== (Session::get('user')->nick ?? null)) {
            return;
        }
        $vehiculoOrden->delete();
    }

    // guarda una incidencia asociada a la orden
    private function guardarIncidencia(): void
    {
        if (isset($_REQUEST['action']) && 'guardarIncidencia' === $_REQUEST['action']) {
            $orden = new Partes();
            $orden->guardarIncidencia($_FILES['files'], $_REQUEST);
        }
    }

    private function guardarMaterialPte(): void
    {
        $material = new OIMaterialProyecto();
        $material->idparte_dia = $this->request->get('iddiaseleccion');
        $material->idproyecto = $this->orden->idproyecto;
        $material->descripcion = $this->request->get('descripcion');
        $material->cantidad = $this->request->get('cantidad');
        $material->pendiente = $this->request->get('pendiente');
        $material->save();
    }

    private function actualizarMaterial(): void
    {
        $material = new OIMaterialProyecto();
        $material->loadFromCode($this->request->get('id'));
        if ($material->nick !== (Session::get('user')->nick ?? null)) {
            return;
        }
        $material->descripcion = $this->request->get('descripcion');
        $material->cantidad = $this->request->get('cantidad');
        $material->save();
    }

    private function eliminarMaterial(): void
    {
        $material = new OIMaterialProyecto();
        $material->loadFromCode($this->request->get('id'));
        if ($material->nick !== (Session::get('user')->nick ?? null)) {
            return;
        }
        $material->delete();
    }

    private function nuevoChecklistDia(): void
    {
        $check = new OIChecklistDia();
        $check->idparte_dia = $this->request->get('iddiaseleccion');
        $check->descripcion = $this->request->get('descripcion');
        $check->marcado = false;
        $check->save();
    }

    private function guardarChecklistDia(): void
    {
        $check = new OIChecklistDia();
        $check->loadFromCode($this->request->get('id'));
        if ($check->nick !== (Session::get('user')->nick ?? null)) {
            return;
        }
        $check->marcado = $this->request->get('marcado') ? true : false;
        $check->save();
    }

    private function eliminarChecklistDia(): void
    {
        $check = new OIChecklistDia();
        $check->loadFromCode($this->request->get('id'));
        if ($check->nick !== (Session::get('user')->nick ?? null)) {
            return;
        }
        $check->delete();
    }

    public function getSelectProductos(): array
    {
        $variante = new \FacturaScripts\Dinamic\Model\Variante();
        $variantes = $variante->all([], [], 0, 0);

        $resultado = [];

        foreach ($variantes as $v) {
            $nombre = $v->referencia . ' ' . $v->description();
            $resultado[$v->referencia] = $nombre;
        }

        return $resultado;
    }

    private function crearAlbaran(): void
    {
        if ((Session::get('user')->level ?? 0) <= 90) {
            return;
        }
        $proyecto = $this->orden->getProyecto();
        if (empty($proyecto->idproyecto)) {
            $this->toolBox()->i18nLog()->warning('El parte no tiene un proyecto asignado');
            return;
        }

        $cliente = new \FacturaScripts\Dinamic\Model\Cliente();
        if (false === $cliente->loadFromCode($proyecto->codcliente)) {
            $this->toolBox()->i18nLog()->warning('El proyecto no tiene un cliente asociado');
            return;
        }

        $albaran = new \FacturaScripts\Dinamic\Model\AlbaranCliente();
        $albaran->setSubject($cliente);
        $albaran->numero2 = $proyecto->numero_pedido;
        if (false === $albaran->save()) {
            $this->toolBox()->i18nLog()->warning('record-save-error');
            return;
        }

        // create lines from resumen asking for references
        $referencias = $this->request->request->get('referencias', []);
        $ordenResumen = $this->orden->getResumen();
        foreach ($ordenResumen as $desc => $cantidad) {
            if (empty($cantidad)) {
                continue;
            }

            $referencia = $referencias[$desc] ?? '';
            if (empty($referencia)) {
                $linea = $albaran->getNewLine();
                $linea->mostrar_precio = false;
            } else {
                $linea = $albaran->getNewProductLine($referencia);
            }

            $linea->descripcion = ucfirst(str_replace('_', ' ', (string) $desc));
            $linea->cantidad = $cantidad;
            $linea->actualizastock = 0;
            $linea->save();
        }

        // recalculate totals
        $lineas = $albaran->getLines();
        Calculator::calculate($albaran, $lineas, true);

        $this->orden->idalbaran = $albaran->idalbaran;
        $this->orden->save();
    }
}
