<?php

namespace FacturaScripts\Plugins\PartesSemanales\Controller;

use FacturaScripts\Core\Lib\ExtendedController\EditController;
use FacturaScripts\Core\Model\AttachedFile;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;

class EditOIncidencia extends EditController
{
    public function getModelClassName(): string
    {
        return "OIncidencia";
    }

    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data["title"] = "Incidencia";
        $data["icon"] = "fas fa-circle-exclamation";
        return $data;
    }

    protected function createViews(): void
    {
        parent::createViews();
        $this->setTabsPosition("bottom");
        $this->createViewsFotoIncidencia();
    }

    private function createViewsFotoIncidencia()
    {
        $this->addHtmlView("FotosIncidencias", "FotosIncidencias", "FotoIncidencia", "Fotos de La Incidencia", "fas fa-camera-retro");
    }


    //nos traemos las fotos de la incidencia
    public function getFotoIncidencia(): array
    {
	    $code = $this->request->get('code');
	    $model = new AttachedFile();
	    $where = [new DataBaseWhere("idincidencia", $code)];
	    return $model->all($where, ["date" => "DESC"], 0, 0);
    }
}
