<?php

namespace FacturaScripts\Plugins\PartesSemanales\Controller;

use FacturaScripts\Core\Lib\ExtendedController\EditController;

class EditOIOperarioTarea extends EditController
{
    public function getModelClassName(): string
    {
        return "OIOperarioTarea";
    }

    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data["title"] = "OIOperarioTarea";
        $data["icon"] = "fas fa-search";
        return $data;
    }

    protected function createViews(): void
    {
        parent::createViews();
        $mainView = $this->getMainViewName();
        $this->setSettings($mainView, 'btnDelete', false);
        $this->setTabsPosition("left-bottom");
        $this->createViewsList();
    }

    protected function createViewsList()
    {
        $this->addListView("ListOiFichajes", "OIFichajes", "Fichajes", "fas fa-user-clock");
        $this->setSettings('ListOiFichajes', 'btnDelete', false);
    }

}
