<?php

namespace FacturaScripts\Plugins\PartesSemanales\Controller;

use FacturaScripts\Core\Lib\ExtendedController\EditController;
use FacturaScripts\Core\Model\AttachedFile;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;

class EditOIMaterialProyecto extends EditController
{
    public function getModelClassName(): string
    {
        return "OIMaterialProyecto";
    }

    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data["title"] = "OIMaterialProyecto";
        $data["icon"] = "fas fa-search";
        return $data;
    }

    protected function createViews(): void
    {
        parent::createViews();
        $this->setTabsPosition("bottom");
        $this->createViewsFoto();
    }

    private function createViewsFoto()
    {
        $this->addHtmlView("FotosIncidencias", "FotosIncidencias", "FotoIncidencia", "Fotos de La Incidencia", "fas fa-camera-retro");
    }


    public function getFotoIncidencia(): array
    {
	    $code = $this->request->get('code');
	    $model = new AttachedFile();
	    $where = [new DataBaseWhere("idmaterial", $code)];
	    return $model->all($where, ["date" => "DESC"], 0, 0);
    }

}
