<?php

namespace FacturaScripts\Plugins\PartesSemanales\Controller;

use FacturaScripts\Core\Lib\ExtendedController\PanelController;

class AdminPartesSemanales extends PanelController
{
    public function getPageData(): array
    {
        $data = parent::getPageData();
        $data['menu'] = 'admin';
        $data['title'] = 'PartesSemanales';
        $data['icon'] = 'fas fa-cog';
        return $data;
    }

    protected function createViews(): void
    {
        $this->setTemplate('EditSettings');
        $this->addEditView('ConfigPartesSemanales', 'Settings', 'general');
    }

    protected function execPreviousAction($action)
    {
        if (in_array($action, ['edit', 'insert']) && isset($this->views['ConfigPartesSemanales'])) {
            $this->views['ConfigPartesSemanales']->model->name = 'partessemanales';
        }
        return parent::execPreviousAction($action);
    }

    protected function loadData($viewName, $view)
    {
        if ($viewName === 'ConfigPartesSemanales') {
            $view->loadData('partessemanales');
            $view->model->name = 'partessemanales';
        }
    }
}
