var saveImages = [];

function guardarImagen(idtarea, archivo) {
  // evita archivos duplicados para la misma tarea
  if (saveImages.some(function(img) {
    return img.idtarea === idtarea && img.archivo.name === archivo.name;
  })) {
    return false;
  }

  saveImages.push({ idtarea: idtarea, archivo: archivo });
  return true;
}

function mostrarImagenesGuardadas(idtarea, name, src){
  var contenedorImagenes = document.getElementById('presentation' + idtarea);
  var id = generarIdLargo(33);
  var html = crearHtmlImagen(id, name, src, idtarea);
  contenedorImagenes.insertAdjacentHTML('beforeend', html);
}

function generarIdLargo(longitud) {
  const caracteres = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
  let id = '';

  for (let i = 0; i < longitud; i++) {
    const indiceAleatorio = Math.floor(Math.random() * caracteres.length);
    id += caracteres.charAt(indiceAleatorio);
  }

  return id;
}

function crearHtmlImagen(id, name, src, idtarea) {
  return `
        <div id="${id}" class="uppy-Dashboard-Item is-resumable">
        <div class="uppy-Dashboard-Item-preview">
        <div class="uppy-Dashboard-Item-previewInnerWrap" style="background-color: rgb(104, 109, 224);">
        <img class="uppy-Dashboard-Item-previewImg" alt="${name}" src="${src}" onclick="showImageModal('${src}', '${name}')">
        </div>
        </div>
        <div class="uppy-Dashboard-Item-fileInfoAndButtons">
          <div class="uppy-Dashboard-Item-fileInfo" data-uppy-file-source="Dashboard">
            <div class="uppy-Dashboard-Item-fileName">
              <div class="uppy-Dashboard-Item-name" title="${name}">${name}</div>
              </div>
            </div>
            <div class="uppy-Dashboard-Item-actionWrapper">
              <button onclick="removeFile('${id}', '${name}', '${src}', '${idtarea}')" class="uppy-u-reset uppy-Dashboard-Item-action uppy-Dashboard-Item-action--remove" type="button" aria-label="Remove file" title="Remove file">
                <i class="fa-solid fa-circle-xmark"></i>
              </button>
            </div>
        </div>
        </div>`;
}

function mostrarImagenes(input, idtarea) {
  var contenedorImagenes = document.getElementById('presentation' + idtarea);

  var archivos = input.files;
  for (let i = 0; i < archivos.length; i++) {
    let archivo = archivos[i];

    if (!guardarImagen(idtarea, archivo)) {
      continue;
    }

    var reader = new FileReader();

    let id = Math.random().toString(36).substr(2, 9);

    reader.onload = function(e) {
      var html = crearHtmlImagen(id, archivo.name, e.target.result, idtarea);
      contenedorImagenes.insertAdjacentHTML('beforeend', html);
    };
    reader.readAsDataURL(archivo);
  }
}

function removeFile(id, nombreArchivo, src, idtarea) {
  $("#" + id).remove();

  var index = saveImages.findIndex(function(imagen) {
    return imagen.idtarea === idtarea && imagen.archivo.name === nombreArchivo;
  });

  if (index !== -1) {
    saveImages.splice(index, 1);
  }

  var inputOculto =
    document.getElementById('imagenesBorradas' + idtarea) ||
    document.getElementById('imagenesBorradas');
  if (inputOculto) {
    if (inputOculto.value) {
      inputOculto.value += ',' + src; // Añade la URL a la lista, separada por comas
    } else {
      inputOculto.value = src; // Si es la primera URL, simplemente asígnala
    }
  }
}

function showImageModal(src, name){
  var modal = document.getElementById('imagePreviewModal');
  if(modal){
    modal.querySelector('img').src = src;
    modal.querySelector('.modal-title').textContent = name || '';
    $('#imagePreviewModal').modal('show');
  }
}

function imprimirModalCamara(idTarea) {
    var modalHTML = `
        <div dir="ltr" class="modal fade" id="modalCamara${idTarea}" tabindex="-1" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body text-center">
                                    <div id="drag-drop-area">
                                        <div class="uppy-Root">
                                            <div class="uppy-Dashboard uppy-Dashboard--animateOpenClose uppy-size--md uppy-size--lg uppy-size--height-md uppy-Dashboard--isInnerWrapVisible" data-uppy-theme=" light" data-uppy-num-acquirers="0" data-uppy-drag-drop-supported="true" aria-hidden="false" aria-disabled="false" aria-label="Uppy Dashboard">
                                                <div class="uppy-Dashboard-inner" aria-modal="false" role="false" style="width: 1148px; height: 550px;">
                                                    <div class="uppy-Dashboard-innerWrap">
                                                        <div class="uppy-DashboardContent-bar">
                                                            <button data-bs-dismiss="modal" class="uppy-DashboardContent-back" type="button">Cancelar</button>
                                                            <button onclick="document.getElementById('archivos${idTarea}').click()" class="uppy-DashboardContent-addMore" type="button" aria-label="Add more files" title="Add more files">
                                                                <i class="fa-solid fa-circle-xmark"></i>
                                                                <span class="uppy-DashboardContent-addMoreCaption">Agregar más</span>
                                                            </button>
                                                        </div>
                                                        <div class="uppy-Dashboard-files" role="list">
                                                            <div role="presentation" style="position: relative; width: 100%; min-height: 100%; height: 200px;">
                                                                <div role="presentation" style="position: absolute; top: 0px; left: 0px; width: 100%; overflow: visible;">
                                                                    <div role="presentation" id="presentation${idTarea}">

                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="uppy-Dashboard-progressindicators">
                                                            <div class="uppy-StatusBar is-waiting" aria-hidden="false">
                                                                <div class="uppy-StatusBar-progress" role="progressbar" aria-label="0%" aria-valuetext="0%" aria-valuemin="0" aria-valuemax="100" aria-valuenow="0" style="width: 0%;"></div>
                                                                <div class="uppy-StatusBar-actions">
                                                                    <button type="button" class="uppy-u-reset uppy-c-btn uppy-StatusBar-actionBtn uppy-StatusBar-actionBtn--upload uppy-c-btn-primary" aria-label="Upload 3 files" data-bs-dismiss="modal" data-uppy-super-focusable="true">Aceptar</button>
                                                                </div>
                                                            </div>
                                                            <div class="uppy uppy-Informer"><span></span></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    `;

    if (!document.getElementById("modalCamara" + idTarea)) {
        document.body.insertAdjacentHTML('beforeend', modalHTML);
    }
}
