<?php

namespace FacturaScripts\Plugins\Partes\Services\Task;

use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Core\Tools;
use FacturaScripts\Dinamic\Model\TareaProyecto;
use FacturaScripts\Dinamic\Model\UsuariosNotificaciones;
use FacturaScripts\Plugins\Partes\Model\OIOperarioTarea;
use FacturaScripts\Plugins\Partes\Model\Partes;

class TaskPersistenceService
{
    public function __construct(private readonly Partes $partes)
    {
    }

    public function prepareTask(TaskContext $context): bool
    {
        $post = $context->allPost();
        $esNueva = $context->isNewFlagged();
        $inputId = $post['idtarea'] ?? null;

        if (!$esNueva && !empty($inputId)) {
            $task = new TareaProyecto();
            $task->loadFromCode($inputId);

            $operarioTarea = new OIOperarioTarea();
            $where = [new DataBaseWhere('idtarea', $inputId)];
            foreach ($operarioTarea->all($where) as $operario) {
                $operario->delete();
            }

            $context->setTask($task, false);
            return true;
        }

        $idproyecto = $post['idproyectoSeleccionado'] ?? $post['idproyecto'] ?? null;
        if (empty($idproyecto)) {
            Tools::log()->error('Debe seleccionar un proyecto');
            return false;
        }

        $task = new TareaProyecto();
        if (!empty($post['esPlantilla'])) {
            $task->plantillatarea = true;
        }
        $task->idproyecto = $idproyecto;
        $task->nombre = $post['nombreTarea'] ?? null;
        $task->cantidad = 1;

        $context->setTask($task, true);
        return true;
    }

    public function applyTaskData(TaskContext $context): void
    {
        $post = $context->allPost();
        $task = $context->task();

        if (isset($post['nombreTarea'])) {
            $task->nombre = $post['nombreTarea'];
        }

        if (isset($post['descripcionTarea'])) {
            $descripcion = $post['descripcionTarea'];
            $task->descripcion = strip_tags($descripcion);
            $task->descripcionHTML = htmlspecialchars($descripcion);
        }

        if (isset($post['idfase'])) {
            $task->idfase = $post['idfase'];
        }

        if (isset($post['idcategoria'])) {
            $task->idcategoria = $post['idcategoria'];
        }

        if (isset($post['idtipotarea'])) {
            $task->idtipotarea = $post['idtipotarea'];
        }

        if (isset($post['fechainicio'])) {
            $task->fechainicio = $post['fechainicio'];
        }

        if (isset($post['fechafin'])) {
            $task->fechafin = $post['fechafin'];
        }

        if (isset($post['fecha'])) {
            $task->fecha = $post['fecha'];
        }

        if (empty($task->fecha)) {
            $task->fecha = $task->fechainicio ?: Tools::date();
        }

        if (isset($post['idorden']) && empty($task->idorden)) {
            $task->idorden = $post['idorden'];
        }
    }

    public function saveTask(TaskContext $context): ?int
    {
        $task = $context->task();

        if ($context->isNewTask()) {
            $task->idtarea = null;
        }

        if (false === $task->save()) {
            Tools::log('partes')->error('No se ha podido guardar la tarea. Revisa los campos obligatorios.', [
                'datos' => $task->toArray(),
            ]);
            return null;
        }

        $idTarea = (int) $task->idtarea;

        if ((int) $task->idfase === 3) {
            $notificaciones = new UsuariosNotificaciones();
            $notificaciones->send(UsuariosNotificaciones::COMPLETAR_TAREA, $task);
        }

        return $idTarea;
    }
}
