<?php

namespace FacturaScripts\Plugins\Partes\Services\Task;

use DateTime;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Plugins\Partes\Model\OIOperarioTarea;
use FacturaScripts\Plugins\Partes\Model\OIFichajes;
use FacturaScripts\Plugins\Partes\Model\Partes;

class TaskOperarioService
{
    public function __construct(private readonly Partes $partes)
    {
    }

    public function prepareAssignments(TaskContext $context): void
    {
        $post = $context->allPost();
        $task = $context->task();

        if (isset($post['responsable'])) {
            $responsables = (array) Partes::decodeJsonList($post['responsable']);
            $task->responsable = $responsables[0] ?? null;

            $operariosLista = isset($post['operarios'])
                ? (array) Partes::decodeJsonList($post['operarios'])
                : [];

            $existe = false;
            foreach ($operariosLista as $operario) {
                $partes = explode('_', (string) $operario);
                if (($partes[0] ?? null) === $task->responsable) {
                    $existe = true;
                    break;
                }
            }

            if (!$existe && $task->responsable) {
                $operariosLista[] = $task->responsable . '_1';
            }

            $post['operarios'] = $operariosLista;
        } else {
            $task->responsable = null;
        }

        if (isset($post['operarios']) && !is_array($post['operarios'])) {
            $post['operarios'] = (array) Partes::decodeJsonList($post['operarios']);
        }

        $context->replacePost($post);
    }

    public function persistAssignments(TaskContext $context, int $idTarea): void
    {
        $post = $context->allPost();

        if (!empty($post['operarios']) && is_array($post['operarios'])) {
            foreach ($post['operarios'] as $operarioRaw) {
                $operarioTarea = new OIOperarioTarea();
                $operarioTarea->horas = 1;
                $operarioTarea->idtarea = $idTarea;
                $operarioTarea->lastnick = 'system';
                $operarioTarea->lastupdate = date('d-m-Y H:i:s');
                $partes = explode('_', (string) $operarioRaw);
                $operarioTarea->nick = $partes[0] ?? null;
                $operarioTarea->save();
            }
        }

        $operarioTarea = new OIOperarioTarea();
        $where = [new DataBaseWhere('idtarea', $idTarea)];
        $operariosModel = $operarioTarea->all($where);

        foreach ($operariosModel as $operario) {
            $inicioKey = 'fichajeinicio_' . $operario->nick;
            $finKey = 'fichajefin_' . $operario->nick;

            $inicioTexto = $post[$inicioKey] ?? '';
            $finTexto = $post[$finKey] ?? '';

            if ($inicioTexto && $finTexto) {
                $fichaje = new OIFichajes();
                $fichaje->inicio = $inicioTexto;
                $fichaje->fin = $finTexto;
                $fichaje->nick = $operario->nick;
                $fichaje->idtarea = $idTarea;
                $fichaje->save();
            }

            $fichajes = (new OIFichajes())->getFichajesByNickIdTarea($operario->nick, $idTarea);

            $totalHoras = 0;
            foreach ($fichajes as $fichaje) {
                $inicio = new DateTime();
                $inicio->setTimestamp(strtotime($fichaje->inicio));
                $fin = new DateTime();
                $fin->setTimestamp(strtotime($fichaje->fin));
                $diff = $inicio->diff($fin);
                $totalHoras += $diff->h + ($diff->days * 24);
            }

            $operario->horas = $totalHoras;
            $operario->save();
        }
    }
}
