<?php

namespace FacturaScripts\Plugins\Partes\Services\Task;

use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Dinamic\Model\AttachedFile;
use FacturaScripts\Dinamic\Model\TareaProyecto;
use FacturaScripts\Plugins\Partes\Model\OIOperarioTarea;
use FacturaScripts\Plugins\Partes\Model\Partes;

class TaskChecklistService
{
    public function __construct(private readonly Partes $partes)
    {
    }

    public function sync(TaskContext $context, int $idTarea, TareaProyecto $parentTask): array
    {
        $post = $context->allPost();
        $targets = $context->getSubtaskTargets();

        if (!isset($post['checklist'])) {
            return $subtaskTargets;
        }

        $checklist = Partes::normalizeChecklistItems($post['checklist']);
        $subTareasModal = isset($post['subTareas']) ? Partes::normalizeSubtaskItems($post['subTareas']) : [];

        $existing = (new TareaProyecto())->all([new DataBaseWhere('idtareapadre', $idTarea)], []);
        $toDelete = [];
        foreach ($existing as $subtarea) {
            $toDelete[$subtarea->idtarea] = $subtarea;
        }

        foreach ($checklist as $item) {
            $rawId = $item['id'] ?? null;
            if (!$rawId) {
                continue;
            }

            $subtask = $this->loadExistingSubtask($rawId, (bool) $context->isNewTask());
            if ($subtask) {
                unset($toDelete[$subtask->idtarea]);
                $this->updateExistingSubtask($subtask, $item, $subTareasModal);
                Partes::registerAttachmentTarget($targets, $rawId, (int) $subtask->idtarea);
                Partes::registerAttachmentTarget($targets, (int) $subtask->idtarea, (int) $subtask->idtarea);
                continue;
            }

            $newSubtask = $this->createSubtask($parentTask, $item);
            Partes::registerAttachmentTarget($targets, $rawId, (int) $newSubtask->idtarea);
            Partes::registerAttachmentTarget($targets, (int) $newSubtask->idtarea, (int) $newSubtask->idtarea);
            $this->transferTemporaryAttachments($rawId, (int) $newSubtask->idtarea);
        }

        foreach ($toDelete as $obsolete) {
            $obsolete->delete();
        }

        $context->setSubtaskTargets($targets);
        return $targets;
    }

    private function loadExistingSubtask($rawId, bool $isNewTask): ?TareaProyecto
    {
        if ($isNewTask) {
            return null;
        }

        $model = new TareaProyecto();
        $where = [new DataBaseWhere('idtarea', $rawId)];
        $subtasks = $model->all($where);

        return $subtasks[0] ?? null;
    }

    private function updateExistingSubtask(TareaProyecto $subtask, array $item, array $subTareasModal): void
    {
        $subtask->nombre = $item['descripcion'] ?? $subtask->nombre;
        if (!empty($item['marcado'])) {
            $subtask->checked = $item['marcado'];
        }

        foreach ($subTareasModal as $modal) {
            if (($modal['idtarea'] ?? null) != $subtask->idtarea) {
                continue;
            }

            $subtask->descripcion = $modal['descripcion'] ?? $subtask->descripcion;
            $subtask->hora_inicio = $modal['hora_inicio'] ?? $subtask->hora_inicio;
            $subtask->hora_fin = $modal['hora_fin'] ?? $subtask->hora_fin;
            $subtask->save();

            if (!empty($modal['comentarios'])) {
                $this->partes->saveComentarios($modal['comentarios'], $subtask->idtarea);
            }

            if (!empty($modal['operarios']) && is_array($modal['operarios'])) {
                foreach ($modal['operarios'] as $operario) {
                    $operarioTarea = new OIOperarioTarea();
                    $operarioTarea->horas = 1;
                    $operarioTarea->idtarea = $modal['idtarea'];
                    $operarioTarea->lastnick = 'system';
                    $operarioTarea->lastupdate = date('d-m-Y H:i:s');
                    $partes = explode('_', (string) $operario);
                    $operarioTarea->nick = $partes[0] ?? null;
                    $operarioTarea->save();
                }
            }
        }
    }

    private function createSubtask(TareaProyecto $parentTask, array $item): TareaProyecto
    {
        $subtask = new TareaProyecto();
        $subtask->idtareapadre = $parentTask->idtarea;
        $subtask->idproyecto = $parentTask->idproyecto;
        $subtask->nombre = $item['descripcion'] ?? '';
        $subtask->checked = $item['marcado'] ?? 0;
        $subtask->cantidad = 0;
        $subtask->idfase = 1;
        $subtask->idcategoria = 0;
        $subtask->save();

        return $subtask;
    }

    private function transferTemporaryAttachments($rawId, int $newId): void
    {
        $tempId = Partes::normalizeAttachmentId($rawId);
        $files = new AttachedFile();
        $where = [new DataBaseWhere('idtarea', $tempId)];

        foreach ($files->all($where) as $archivoTmp) {
            $archivoTmp->idtarea = $newId;
            $archivoTmp->save();
        }
    }
}
