<?php
namespace FacturaScripts\Plugins\Partes\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Tools;
class TipoTarea extends ModelClass
{
    use ModelTrait;

    /** @var int */
    public $id;

    /** @var string */
    public $tipotarea;

    public function clear() 
    {
        parent::clear();
    }

    public static function primaryColumn(): string
    {
        return "id";
    }

    public static function tableName(): string
    {
        return "tipos_tarea";
    }

    public function test(): bool
    {
        $this->tipotarea = Tools::noHtml($this->tipotarea);
        return parent::test();
    }

    public function url(string $type = 'auto', string $list = 'List'): string
    {
        if ($type === 'list') {
            return 'ListTareaProyecto#ListTipoTarea';
        }

        return parent::url($type, $list);
    }
}
