<?php
namespace FacturaScripts\Plugins\Partes\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Tools;
use FacturaScripts\Dinamic\Model\Proyecto;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;

class TareasHoras extends ModelClass
{
    use ModelTrait;

    /** @var int */
    public $horastotales;

    /** @var int */
    public $idtarea;

    public function clear() 
    {
        parent::clear();
        $this->horastotales = 0;
        $this->idtarea = 0;
    }

    public static function primaryColumn(): string
    {
        return "idtarea";
    }

    public static function tableName(): string
    {
        return "tareas";
    }

    public function test(): bool
    {
        return parent::test();
    }

    public function url(string $type = 'auto', string $list = 'List'): string
    {
        // Si el tipo que estamos pidiendo la URL del listado, devuelve la  URL del proyecto.
        return $type == 'list' ?
            $this->getProyecto()->url() :
            parent::url($type, $list);
    }

    public function getProyecto(): Proyecto
    {
        $proyecto = new Proyecto();
        $proyecto->loadFromCode($this->idproyecto);
        return $proyecto;
    }

    public function save(): bool
    {

        if (false === parent::save()) {
            return false;
        }

	$fichajes = new OIFichajes();
	$where = [new DataBaseWhere('idtarea', $this->idtarea)];
	$fichajes = $fichajes->all($where);

	foreach($fichajes as $fichaje){
		$fichaje->save();
	}

	$fichajes = new OIFichajes();
	$where = [new DataBaseWhere('idtarea', $this->idtarea)];
	$fichajes = $fichajes->all($where);

	return true;

    }


}
