<?php

namespace FacturaScripts\Plugins\Partes\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Session;
use FacturaScripts\Core\Tools;

class OIncidencia extends ModelClass
{
    use ModelTrait;

    /** @var string */
    public $creationdate;

    /** @var string */
    public $descripcion_incidencia;

    /** @var string */
    public $estado;

    /** @var int */
    public $id;

    /** @var int */
    public $idproyecto;

    /** @var int */
    public $idorden;

    /** @var string */
    public $lastnick;

    /** @var string */
    public $lastupdate;

    /** @var string */
    public $name;


    /** @var string */
    public $nick;

    public function clear()
    {
        parent::clear();
        $this->creationdate = date(self::DATETIME_STYLE);
        $this->estado = false;
        $this->nick = Session::get('user')->nick ?? null;
        $this->idorden = 0;
        $this->idproyecto = 0;
    }

    public static function primaryColumn(): string
    {
        return "id";
    }

    public static function tableName(): string
    {
        return "o_incidencia";
    }

    public function test(): bool
    {
        $this->descripcion_incidencia = Tools::noHtml($this->descripcion_incidencia);
        //$this->fotos = Tools::noHtml($this->fotos);
        $this->lastnick = Tools::noHtml($this->lastnick);
        $this->name = Tools::noHtml($this->name);
        $this->nick = Tools::noHtml($this->nick);
        return parent::test();
    }

    protected function saveInsert(array $values = []): bool
    {
        $this->lastupdate = null;
        $this->lastnick = null;
        return parent::saveInsert($values);
    }

    protected function saveUpdate(array $values = []): bool
    {
        $this->lastupdate = date(self::DATETIME_STYLE);
       $this->lastnick = Session::get('user')->nick ?? null;
       return parent::saveUpdate($values);
    }

    public function url(string $type = 'auto', string $list = 'List'): string
    {
        return $type === 'list'
            ? 'ListProyecto#ListOiFichajes'
            : parent::url($type, $list);
    }
}
