<?php

namespace FacturaScripts\Plugins\Partes\Model;

use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Dinamic\Model\TareaProyecto as ParentClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Session;
use FacturaScripts\Core\Tools;
use FacturaScripts\Dinamic\Model\Proyecto;
use FacturaScripts\Plugins\Partes\Model\OIOperarioTarea;
use FacturaScripts\Dinamic\Model\OIProyecto;

class OITareaProyecto extends ParentClass
{
	public function getTareas($idproyecto = null){

		$return = [];

		if($idproyecto){
			$where = [new DataBaseWhere('idproyecto', $idproyecto)];
			$tareas = $this->all($where);
		}else{
			$tareas = $this->all([], [],0 ,0);
		}

		foreach($tareas as $tarea){

			if($this->suProyectoEsPlantilla($tarea)){
				continue;
			}

			if($tarea->idtareapadre != "" || $tarea->plantillatarea != ""){
				continue;
			}
			$return[] = $tarea;
		}
		return $return;
	}

	public function suProyectoEsPlantilla($tarea)
	{
		$where = [
			new DataBaseWhere('idproyecto', $tarea->idproyecto),
			new DataBaseWhere('plantilla_proyecto', 1, "="),
		];
		$proyecto = (new OIProyecto)->all($where);
		return count($proyecto) > 0;
	}

	public function getPlantilla()
	{
		return $this->all([
			new DataBaseWhere('plantillatarea', null, "!=")
		]);
	}

	public function getSubTask()
	{
		return $this->all(
			[
				new DataBaseWhere('idtareapadre', $this->idtarea),
				new DataBaseWhere('idproyecto', $this->idproyecto)
			],
		);
	}

	public function getResponsable()
	{

	}

	public function getOperarios()
	{
		return (new OIOperarioTarea)->loadByIDTarea($this->idtarea);
	}

	public function deleteSubTaskByParent($idtarea)
	{
		$subTask = $this->all(
			[
				new DataBaseWhere('idtareapadre', $idtarea),
			],
		);
		foreach($subTask as $task){
			$task->delete();
		}
	}

}
