<?php

namespace FacturaScripts\Plugins\Partes\Model;

use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Dinamic\Model\Proyecto as ParentClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Session;
use FacturaScripts\Core\Tools;
use FacturaScripts\Dinamic\Model\Proyecto;

class OIProyecto extends ParentClass
{

	public function getDataKanban($idproyecto=null)
	{
		if($idproyecto){
			$where = [new DataBaseWhere('idproyecto', $idproyecto)];
			$proyectos = $this->all($where);
		}else{
			$proyectos = $this->all([], [], 0, 0);
		}

		$modelTareas = new \FacturaScripts\Dinamic\Model\OITareaProyecto();
		$tareas = $modelTareas->getTareas($idproyecto);

		$modelKanban = new \FacturaScripts\Dinamic\Model\FaseTarea();
		$kanban = $modelKanban->all([], []);


		$proyectoIdNombre = array();

		foreach ($proyectos as $proyecto) {
			$idProyecto = $proyecto->idproyecto;
			$nombreProyecto = $proyecto->nombre;
			$proyectoIdNombre[$idProyecto] = $nombreProyecto;
		}

		foreach($kanban as $row)
		{
			$estructura[$row->idfase] = [
				"idfase" => $row->idfase,
				"id" => $row->nombre,
				"title" => $row->nombre,
				"class" => "info, good",
				"item" => [],
				"color" => $row->color_fase_tarea
			];
		}



		foreach($tareas as $tarea){
			if($tarea->idtareapadre != ""){
				continue;
			}
			$modelSubTask = new \FacturaScripts\Dinamic\Model\TareaProyecto();
			$where = [new DataBaseWhere('idtareapadre', $tarea->idtarea)];
			$subTask = $modelSubTask->all($where);

			$modelSubTask = new \FacturaScripts\Dinamic\Model\TareaProyecto();
			$where = [
				new DataBaseWhere('idtareapadre', $tarea->idtarea),
				    new DataBaseWhere('checked', 1),
			];
			$subTaskChecked = $modelSubTask->all($where);

			$kanban = &$estructura[$tarea->idfase];
			$kanban["item"][] = [
				"title" => $tarea->nombre,
				"idtarea" => $tarea->idtarea,
				"nombreProyecto" => $proyectoIdNombre[$tarea->idproyecto],
				"descripcion" => $tarea->descripcion,
				"idtarea" => $tarea->idtarea,
				"idproyecto" => $tarea->idproyecto,
				"subtareaTotal" => count($subTask),
				"subtareaMarcada" => count($subTaskChecked),
				"fecha_limite" => $tarea->fechafin,
				"operarios" => (new OIUser)->getOperariosTarea($tarea->idtarea),
			];
		}

		return $estructura;

	}

	public function getDataGanttFrappe($idproyecto = null)
	{
		$return = [];

		$modelTareas = new \FacturaScripts\Dinamic\Model\OITareaProyecto();
		$data = $modelTareas->getTareas($idproyecto);

		$id = 0;
		foreach($data as $row){

			if(($row->idtareapadre != "")){
				continue;
			}

			if($row->fechainicio == "" || $row->fechafin == ""){
				continue;
			}

			$idtareaName = "Tarea" . $row->idtarea;

			$task = [
				"id" => $idtareaName,
				"name" => $row->nombre,
				"start" => $this->convertirFecha($row->fechainicio),
				"end" => $this->convertirFecha($row->fechafin),
				"dependencies" => null
			];
			$return[] = $task;

			$modelSubTask = new \FacturaScripts\Dinamic\Model\TareaProyecto();
			$where = [new DataBaseWhere('idtareapadre', $row->idtarea)];
			$subTaskRow = $modelSubTask->all($where);

			foreach($subTaskRow as $rowSubTask){
				$return[] = [
					"id" => "SubTarea" . $id,
					"name" => $rowSubTask->nombre,
					"start" => $this->convertirFecha($row->fechainicio),
					"end" => $this->convertirFecha($row->fechafin),
					"dependencies" => $idtareaName
				];
				$id++;
			}
		}

		return $return;
	}

	public function convertirFecha($fecha_original=null) {
		$fecha_nueva = date("Y-m-d", strtotime($fecha_original));
		return $fecha_nueva;
	}

	public function getProyectos()
	{
		$return = [];
		$where = [
			new DataBaseWhere('editable', true),
			new DataBaseWhere('plantilla_proyecto', false)
		];

		$user = Session::user();
		if ($user !== null && false === $user->admin) {
			$where[] = new DataBaseWhere('idempresa', $user->idempresa);
			$where[] = new DataBaseWhere('privado', false);
		}

		$proyectos = $this->all($where, [], 0, 0);
		foreach($proyectos as $proyecto){
			if(!empty($proyecto->plantilla_proyecto)){
				continue;
			}
			$return[] = $proyecto;
		}

		return $return;
	}

}
