<?php
namespace FacturaScripts\Plugins\Partes\Model;

use FacturaScripts\Core\Model\Base\ModelClass;
use FacturaScripts\Core\Model\Base\ModelTrait;
use FacturaScripts\Core\Tools;
class Categoria extends ModelClass
{
    use ModelTrait;

    /** @var string */
    public $categoria;

    /** @var int */
    public $id;

    public function clear() 
    {
        parent::clear();
    }

    public static function primaryColumn(): string
    {
        return "id";
    }

    public static function tableName(): string
    {
        return "categorias";
    }

    public function test(): bool
    {
        $this->categoria = Tools::noHtml($this->categoria);
        return parent::test();
    }

    public function url(string $type = 'auto', string $list = 'List'): string
    {
        if ($type === 'list') {
            return 'ListTareaProyecto#ListCategoria';
        }

        return parent::url($type, $list);
    }
}
