<?php

namespace FacturaScripts\Plugins\Partes\Lib\Widget;

use FacturaScripts\Core\Lib\AssetManager;
use FacturaScripts\Core\Lib\Widget\WidgetSelect;
use FacturaScripts\Dinamic\Model\TareaProyecto;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Dinamic\Model\AttachedFile;
use FacturaScripts\Core\Base\MyFilesToken;

/**
 * Description of WidgetHtml
 *
 * @author Carlos Garcia Gomez <carlos@facturascripts.com>
 */
class WidgetNickImageOperarios extends WidgetSelect
{

    /**
     * 
     * @param array $data
     */
    public function __construct($data)
    {
        parent::__construct($data);
    }

    /**
     * Adds needed assets to the asset manager.
     */
    protected function assets()
    {

    }

    /**
     * 
     * @param string $type
     * @param string $extraClass
     *
     * @return string
     */
    protected function inputHtml($type = 'text', $extraClass = '')
	{
        return parent::inputHtml($type, $extraClass);
    }

    /**
     *
     * @return string
     */
	protected function show()
	{   
		$idtarea = $this->value;

		$operarioTarea = new \FacturaScripts\Plugins\Partes\Model\OIOperarioTarea();
		$where = [new DataBaseWhere('idtarea', $idtarea)];
		$operariosTarea = $operarioTarea->all($where);

		if (!$operariosTarea) {
			return "-";
		}

		$html = '';

		foreach ($operariosTarea as $operario) {

			$user = new \FacturaScripts\Dinamic\Model\User();
			$user->loadFromCode($operario->nick);

			$url = null;

			if ($user->image_profile) {
				$file = new AttachedFile();
				$file->loadFromCode($user->image_profile);
				$url = "/" . $file->path . '?myft=' . MyFilesToken::get($file->path, true);
			}

			$firstLetter = strtoupper(substr($operario->nick, 0, 1));
			$fullName = htmlspecialchars($operario->nick);

			if ($url) {
				$content = '<img src="' . $url . '" alt="' . $fullName . '" title="' . $fullName . '"
							class="img-fluid rounded-circle w-100 h-100" style="object-fit: cover;">';
			} else {
				$content = '<span class="fw-bold">' . $firstLetter . '</span>';
			}

			$html .= '
			<div class="d-flex align-items-center justify-content-center rounded-circle bg-primary text-white me-2 shadow-sm"
				 style="width: 40px; height: 40px; overflow: hidden;"
				 title="' . $fullName . '" data-bs-toggle="tooltip">
				' . $content . '
			</div>';
		}

		return '<div class="d-flex align-items-center">' . $html . '</div>';
	}







}
