<?php
namespace FacturaScripts\Plugins\Partes\Lib\Widget;

use FacturaScripts\Core\Lib\Widget\WidgetMoney;

/**
 * Widget to display the hourly price of a time log.
 */
class WidgetMostrarPrecioHora extends WidgetMoney
{
    /**
     * @param object $model
     */
    protected function setValue($model)
    {
        parent::setValue($model);
        $horas = (float) ($model->horas ?? 0);
        $this->value = $horas > 0 ? $this->value / $horas : 0.0;
    }
}
