<?php
namespace FacturaScripts\Plugins\Partes\Lib\Widget;

use FacturaScripts\Core\Lib\Widget\BaseWidget;
use FacturaScripts\Dinamic\Model\User;

class WidgetMostrarNick extends BaseWidget
{
    public function __construct($data)
    {
        parent::__construct($data);
    }

    protected function assets()
    {
    }

    protected function inputHtml($type = 'text', $extraClass = '')
    {
        return parent::inputHtml($type, $extraClass);
    }

    protected function show()
    {
        $nick = $this->value;
        if (empty($nick)) {
            return '';
        }

        $user = new User();
        if (false === $user->loadFromCode($nick)) {
            return $nick;
        }

        return '<a href="' . $user->url() . '">' . $user->nick . '</a>';
    }
}
