<?php
namespace FacturaScripts\Plugins\Partes\Model\Join;

use FacturaScripts\Core\Model\Base\JoinModel;
use FacturaScripts\Plugins\Partes\Model\OIOperarioTarea as MasterModel;

class OIOperarioTarea extends JoinModel
{
    public function __construct(array $data = [])
    {
        parent::__construct($data);
        $this->setMasterModel(new MasterModel());
    }

    protected function getFields(): array
    {
        return [
            'id' => 'oi_operarios_tareas.id',
            'idtarea' => 'oi_operarios_tareas.idtarea',
            'nick' => 'oi_operarios_tareas.nick',
            'horas' => 'oi_operarios_tareas.horas',
            'idproyecto' => 'tareas.idproyecto',
            'responsable' => 'uresp.nick',
            'coste_hora' => 'oi_operarios_tareas.coste_hora',
            'total' => 'oi_operarios_tareas.total'
        ];
    }

    protected function getSQLFrom(): string
    {
        return 'oi_operarios_tareas'
            . ' INNER JOIN tareas ON tareas.idtarea = oi_operarios_tareas.idtarea'
            . ' LEFT JOIN users uresp ON uresp.id = tareas.responsable';
    }

    protected function getTables(): array
    {
        return ['oi_operarios_tareas', 'tareas', 'users uresp'];
    }
}
