<?php

namespace FacturaScripts\Plugins\Partes;

use FacturaScripts\Core\Base\InitClass;
use FacturaScripts\Core\Tools;

class Init extends InitClass
{
    public function init()
    {
        // se ejecuta cada vez que carga FacturaScripts (si este plugin está activado).
        $this->loadExtension(new Extension\Controller\EditProyecto());
        $this->loadExtension(new Extension\Controller\ListProyecto());
        $this->loadExtension(new Extension\Controller\EditTareaProyecto());
        $this->loadExtension(new Extension\Model\TareaProyecto());
        $this->loadExtension(new Extension\Controller\ListTareaProyecto());
        $this->loadExtension(new Extension\Model\Proyecto());
    }

    public function update()
    {
        // valores por defecto de configuración
        $defaults = [
            'planos' => 1,
            'vehiculo_kilometraje' => 1,
            'material_pendiente' => 1,
            'nuevo_checklist' => 1,
            'nuevo_fichaje' => 1,
            'nueva_observacion' => 1,
            'imagenes' => 1,
            'incidencias' => 1,
        ];

        foreach ($defaults as $key => $value) {
            Tools::settings('partes', $key, $value);
        }
        Tools::settingsSave();
    }
}
