<?php
namespace FacturaScripts\Plugins\Partes\Extension\Controller;

use Closure;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Dinamic\Lib\AssetManager;
use FacturaScripts\Core\Lib\ExtendedController\HtmlView;
use FacturaScripts\Dinamic\Model\OIUser;
use FacturaScripts\Core\Tools;
use FacturaScripts\Dinamic\Model\OIProyecto;
use FacturaScripts\Dinamic\Model\OITareaProyecto;

class ListTareaProyecto
{
	const MODEL_NAMESPACE = '\\FacturaScripts\\Dinamic\\Model\\';

	public function createViews(): Closure
	{
		return function() {
			$this->filtrarTareas();

                        $this->createviewCategoria();
                        $this->createviewTipoTarea();
                        $this->createviewPlantillas();

			$this->filters();

//			$this->newButtons();

		};
	}

	protected function newButtons()
	{
		return function () {
            $this->addButton('ListTareaProyecto', [
				'type' => 'modal',
                'action' => 'NuevaTarea',
                'icon' => 'fas fa-plus-circle',
                'label' => 'Nueva Tarea',
                'color' => 'success',
            ]);
		};
	}

	protected function createViewGantt(){
		return function () {
			$viewName = "TareasGanttFrappeView";
			$view = new HtmlView($viewName, "Gantt", self::MODEL_NAMESPACE . "Join\TareaProyecto", $viewName, 'fas fa-file');
			$this->addCustomView($viewName, $view);
		};
	}

	protected function createViewKanban(){
		return function () {
			$viewName = "HopeKanbanTareas";
			$view = new HtmlView($viewName, "Kanban", self::MODEL_NAMESPACE . "Join\TareaProyecto", $viewName, 'fas fa-file');
			$this->addCustomView($viewName, $view);
		};
	}

	protected function filtrarTareas(){
		return function () {
			$this->addFilterSelectWhere("ListTareaProyecto", 'template', [
				['label' => Tools::lang()->trans('templates'), 'where' => [
					new DataBaseWhere('idtareapadre', null, "="),
					new DataBaseWhere('plantillatarea', null, "="),
					new DataBaseWhere('proyectos.plantilla_proyecto', 1, "!=")
				]]
			]);
		};
	}

	protected function addHtmlView(string $viewName=null, string $fileName=null, string $modelName=null, string $viewTitle=null, string $viewIcon = 'fab fa-html5')
	{
		if(!$viewName){
			return;
		}
		$view = new HtmlView($viewName, $viewTitle, self::MODEL_NAMESPACE . $modelName, $fileName, $viewIcon);
		$this->addCustomView($viewName, $view);
	}

	public function execAfterAction(): Closure
	{
		return function($action) {

			if($action == "delete"){
				$idtarea = $_POST['code'][0];
				(new OITareaProyecto)->deleteSubTaskByParent($idtarea);
			}
			// tu código aquí
			// execAfterAction() se ejecuta tras el execAfterAction() del controlador.
		};
	}

	public function execPreviousAction(): Closure
	{
		return function($action) {
			// tu código aquí
			// execPreviousAction() se ejecuta después del execPreviousAction() del controlador.
			// Si devolvemos false detenemos la ejecución del controlador.
		};
	}

	public function loadData(): Closure
	{
		$that = $this; // Capturar el contexto actual de $this

		return function($viewName, $view) use ($that) {
			if($viewName == "TareasGanttFrappeView"){
				$this->gantt = (new OIProyecto)->getDataGanttFrappe();
			}

			if($viewName == "HopeKanbanTareas"){
				$this->kanban = (new OIProyecto)->getDataKanban();
			}

			if($viewName == "ListTareaProyecto"){
			}
		};
	}

	public function actualizarKanban()
	{
		if (isset($_POST['idtarea']) && isset($_POST['fase'])) {
			$idTarea = $_POST['idtarea'];
			$fase = $_POST['fase'];
			$idfase = str_replace('group', '', $fase);
			$modelTareas = new \FacturaScripts\Dinamic\Model\TareaProyecto();
			if ($modelTareas->loadFromCode($idTarea)) {
				$modelTareas->idfase = $idfase;
				$modelTareas->save();
			}
		}
	}

	protected function createviewPlantillas()
	{
		return function ($viewName = 'ListTareaProyectoPlantilla') {


			$this->addView($viewName, 'Join\TareaProyecto', 'templates', 'fas fa-pencil-ruler');

			$this->addFilterSelectWhere($viewName, 'template', [
				[ 'where' => [
					new DataBaseWhere('plantillatarea', 1)
				]]
			]);
		};
	}

        protected function createviewCategoria()
        {
                return function ($viewName = 'ListCategoria') {
                        $this->addView($viewName, 'Categoria', 'Categoria', 'fas fa-pencil-ruler');
                };
        }

        protected function createviewTipoTarea()
        {
                return function ($viewName = 'ListTipoTarea') {
                        $this->addView($viewName, 'TipoTarea', 'Tipo de tarea', 'fas fa-pencil-ruler');
                };
        }

	protected function filters()
	{
		return function () {
			$viewName = "ListTareaProyecto";
			$categorias = $this->codeModel->all('categorias', 'id', 'categoria');
			$tipostareas = $this->codeModel->all('tipos_tarea', 'id', 'tipotarea');

			$this->addFilterSelect($viewName, 'idcategoria', 'Categorias', 'tareas.idcategoria', $categorias);
			$this->addFilterSelect($viewName, 'idtipotarea', 'Tipos', 'tareas.idtipotarea', $tipostareas);
		};
	}

}
