<?php

namespace FacturaScripts\Plugins\Partes\Extension\Controller;

use Closure;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;
use FacturaScripts\Dinamic\Model\FaseTarea;
use FacturaScripts\Plugins\Partes\Model\Categoria;
use FacturaScripts\Dinamic\Model\TipoTarea;
use FacturaScripts\Plugins\Partes\Model\OIOperarioTarea;
use FacturaScripts\Dinamic\Model\Proyecto;
use FacturaScripts\Dinamic\Model\TareaProyecto;
use FacturaScripts\Dinamic\Model\User;
use FacturaScripts\Core\Lib\ExtendedController\HtmlView;
use FacturaScripts\Plugins\Partes\Model\ArchivosTareas;
use Symfony\Component\HttpFoundation\File\Exception\FileNotFoundException;
use FacturaScripts\Plugins\Partes\Model\Partes;
use FacturaScripts\Plugins\Partes\Model\OIProyecto;
use FacturaScripts\Dinamic\Model\OIUser;
use FacturaScripts\Core\Model\AttachedFile;
use FacturaScripts\Dinamic\Model\OITareaProyecto;
use FacturaScripts\Plugins\Partes\Extension\Controller\EditProyecto;
use FacturaScripts\Dinamic\Model\OIFichajes;

class EditTareaProyecto
{

    public function createViews(): Closure
    {
        return function () {
	    $viewName = "NewEditTareaProyecto";
	    $this->setTemplate($viewName);


	    $view = new HtmlView($viewName, "Tarea", self::MODEL_NAMESPACE . "Join\TareaProyecto", $viewName, 'fas fa-project-diagram');
	    $this->addCustomView($viewName, $view);


        };
    }

	protected function addHtmlView(string $viewName=null, string $fileName=null, string $modelName=null, string $viewTitle=null, string $viewIcon = 'fab fa-html5')
	{
		if(!$viewName){
			return;
		}
		$view = new HtmlView($viewName, $viewTitle, self::MODEL_NAMESPACE . $modelName, $fileName, $viewIcon);
		$this->addCustomView($viewName, $view);
	}

    public function execAfterAction(): Closure
    {
        return function ($action) {
            // tu código aquí
            // execAfterAction() se ejecuta tras el execAfterAction() del controlador.
        };
    }

    public function execPreviousAction(): Closure
    {
        return function ($action) {
            // tu código aquí
            // execPreviousAction() se ejecuta después del execPreviousAction() del controlador.
            // Si devolvemos false detenemos la ejecución del controlador.
        };
    }

    public function loadData(): Closure
    {
	$that = $this;
	return function($viewName, $view, $isNew=false) use ($that) {

		$newPlantilla = $this->request->get('plantillatarea');

		if($newPlantilla){
			// Obtener la URL actual
			$url = strtok($_SERVER["REQUEST_URI"], '?');
			// Agregar los nuevos parámetros
			$newParams = http_build_query(array(
				'esNuevaTarea' => 'true',
				'esPlantilla' => 'true'
			));
			// Redirigir a la URL limpia con los nuevos parámetros
			header("Location: $url?$newParams");
			return;
		}


		$id = $this->request->get('code');



		if($isNew){
			$id = false;
		}
	    $isPlantilla = $this->request->get('esPlantilla');
	    $isNew = !$id;

		$idproyecto = $this->request->get('idproyecto');

	    if($id){
		    $this->datos = $that->getTarea($id);
	    }else{
		    $this->datos = $that->getNuevaTarea($idproyecto);
	    }


            $idorden = $this->request->get('idorden');
	    if($idorden){
		$this->datos['idorden'] = $idorden;
	    }

	    $code = $this->request->get('code');
	    if($code){
		    $model = new AttachedFile();
		    $where = [new DataBaseWhere("idtarea", $code)];
		    $this->datos['imagenes'] = $model->all($where, ["date" => "DESC"], 0, 0);
	    }

	    $this->urlProyecto = $that->urlProyecto();
	    $this->urlPartes = $that->urlPartes();

	    if(!isset($this->datos['tarea'])){
		    $this->datos['tarea'] = [
			    "idtarea" => rand(100000, 100000000),
		    ];
	    }

		$this->datos['esPlantilla'] = $isPlantilla;
		if($isNew){
			$this->datos['esNuevaTarea'] = true;
		}else{
			$this->datos['esNuevaTarea'] = $this->request->get('esNuevaTarea') || !$id;
		}

	    $this->datos['plantillatarea'] =(new OITareaProyecto)->getPlantilla();
	    $this->datos['proyectos'] = (new OIProyecto)->getProyectos();

		$this->tarea = $this;

            switch ($viewName) {
                case 'EditOIOperarioTarea':
                case 'EditOIncidencia':
                    $where = [new DataBaseWhere('idtarea', $id)];
                    $view->loadData('', $where);
                    break;
            }
        };
    }

	public function getNuevaTarea($idproyecto=false)
	{
		$return = [
			"esNuevaTarea" => true,
			"fases" => (new FaseTarea)->all(),
			"categorias" => (new Categoria)->all(),
			"tipostarea" => (new TipoTarea)->all(),
			"operarios" => (new OIUser)->getOperarios(),
			"proyectos" => (new OIProyecto)->getProyectos(),
			"idproyecto" => $idproyecto,
		];
		return $return;
	}


	public function getTarea($id=null)
	{
		if(!$id){
			return;
		}

		$modelFases = new FaseTarea();
		$fases = $modelFases->all([], []);
		$categorias = (new Categoria)->all();

		$tipotarea = (new TipoTarea)->all();

		$model = new TareaProyecto();
		$where = [new DataBaseWhere('idtarea', $id)];
		$tarea = $model->all($where);


		$modelProyectos = new Proyecto();
		$where = [new DataBaseWhere('idproyecto', $tarea[0]->idproyecto)];
		$proyecto = $modelProyectos->all($where);


		$modelFase = new FaseTarea();
		$where = [new DataBaseWhere('idfase', $tarea[0]->idfase)];
		$fase = $modelFase->all($where);

		$modelSubTask = new TareaProyecto();
		$where = [new DataBaseWhere('idtareapadre', $id)];
		$subTask = $modelSubTask->all($where);

		$operarioTarea = new \FacturaScripts\Plugins\Partes\Model\OIOperarioTarea();
		$where = [new DataBaseWhere('idtarea', $id)];
		$operariosTarea = $operarioTarea->all($where);

		foreach($subTask as &$subTarea){
			$archivosTareas = new ArchivosTareas();

			$comentariosTareas = new \FacturaScripts\Dinamic\Model\OiComentariosTareas();
			$where = [
				new DataBaseWhere('idtarea', $subTarea->idtarea)
			];
			$comentariosTareas = $comentariosTareas->all($where);

			if(count($comentariosTareas) > 0)
				$subTarea->comentarios = $comentariosTareas[0]->comentario;

			$where = [
				new DataBaseWhere('id_tarea', $subTarea->idtarea)
			];

			$operarioSubTarea = new OIOperarioTarea();
			$where = [new DataBaseWhere('idtarea', $subTarea->idtarea)];
			$operariosModel = $operarioSubTarea->all($where);

			$subTarea->operarios = [];
			foreach($operariosModel as $operarioSubTarea){
				$subTarea->operarios = $operarioSubTarea->nick;
			}

			$archivosSubTareas = new \FacturaScripts\Dinamic\Model\AttachedFile();
			$where = [
				new DataBaseWhere('idtarea', $subTarea->idtarea),
			];
			$archivosSubTareas = $archivosSubTareas->all($where);
			$subTarea->files = $archivosSubTareas;
		}

		$comentarios = [];
		$comentariosTareas = new \FacturaScripts\Dinamic\Model\OiComentariosTareas();
		$where = [
			new DataBaseWhere('idtarea', $id)
		];
		$comentariosTareas = $comentariosTareas->all($where);
		if(count($comentariosTareas) > 0){
			foreach($comentariosTareas as $comentariosTarea){
				$comentarios[] = $this->decodeHtmlEntity($comentariosTarea->comentario);
			}
				
		}
		$archivosTareas = new \FacturaScripts\Dinamic\Model\AttachedFile();
		$where = [
			new DataBaseWhere('idtarea', $id),
		];
		$archivosTareas = $archivosTareas->all($where);

		return [
			"proyecto" => $proyecto[0],
			"tarea" => $tarea[0],
			"fase" => $fase[0],
			"fases" => $fases,
			"categorias" => $categorias,
			"tipostarea" => $tipotarea,
			"checklist" => $subTask,
			"operarios" => (new OIUser)->getOperarios(),
			"operariosTarea" => $operariosTarea,
			"comentarios" => $comentarios,
			"files" => $archivosTareas,
			"fichajes" => (new OiFichajes)->getFichajes($id),
		];

	}

	public function actualizarTarea()
	{
		$modelTareas = null;

		if(!isset($_REQUEST['action']) || $_REQUEST['action'] != "actualizarTarea"){
			return;
		}

		if (isset($_POST['idtarea'])) {
			$idTarea = $_POST['idtarea'];
			$modelTareas = new TareaProyecto();
			$operarioTarea = new OIOperarioTarea();


			$where = [new DataBaseWhere('idtarea', $idTarea)];
			$operariosModel = $operarioTarea->all($where);

			foreach($operariosModel as $operario){
				$operario->delete();
			}
			$modelTareas->loadFromCode($idTarea);
		}

		$_POST['update_task'] = true;
		$ordenInstalacion = new Partes();
		return $ordenInstalacion->actualizarTarea();
	}

	public function guardarImagenTarea(){

		if(count($_REQUEST) == 0 || !isset($_REQUEST['action']) || $_REQUEST['action'] != "guardarImagenTarea"){
			return;
		}

		$ordenInstalacion = new Partes();
		$respuesta = [
			'success' => true,
			'uploaded' => [
				'tarea' => 0,
				'subtareas' => 0,
			],
		];

		if(isset($_FILES['files']) && count($_FILES['files']) > 0){
			$respuesta['uploaded']['tarea'] = $ordenInstalacion->guardarImagenTarea($_FILES['files'], $_POST['idtarea'] ?? null);
		}

		if(isset($_FILES['filesSubtarea']) && count($_FILES['filesSubtarea']) > 0){
			$respuesta['uploaded']['subtareas'] = $ordenInstalacion->guardarImagenTarea($_FILES['filesSubtarea'], $_POST['idtareaSubtarea'] ?? []);
		}

		header('Content-Type: application/json');
		echo json_encode($respuesta);
		exit;
	}

	public function urlProyecto(){
		$uri = $_SERVER['REQUEST_URI'];
		if (strpos($uri, "facturas") !== false) {
			return "/facturas/EditProyecto";
		} else {
			return "EditProyecto";
		}
	}

	public function urlPartes(){
		$uri = $_SERVER['REQUEST_URI'];
		if (strpos($uri, "facturas") !== false) {
			return "/facturas/EditPartes";
		} else {
			return "EditPartes";
		}
	}

	public function decodeHtmlEntity($str=null) {

		if(!$str){
			return;
		}
	

		$str = strip_tags($str);

		$entities = array(
				'lt' => '<',
				'gt' => '>',
				'amp' => '&',
				);

		$return = preg_replace_callback('/&([a-z]+);/i', function($match) use ($entities) {
				return isset($entities[$match[1]]) ? $entities[$match[1]] : $match[0];
				}, $str);
		return strip_tags($return);


	}

}
