<?php

namespace FacturaScripts\Plugins\Partes\Controller;

use Closure;
use FacturaScripts\Plugins\Partes\Model\OIOperarioTarea;
use FacturaScripts\Plugins\Partes\Controller\EditOIVehiculoOrden;
use FacturaScripts\Core\Lib\ExtendedController\ListController;
use FacturaScripts\Core\Base\DataBase\DataBaseWhere;

class ListPartes extends ListController
{
	public function getPageData(): array
	{
		$data = parent::getPageData();
		$data["title"] = "Ordenes de Instalacion";
		$data["icon"] = "fas fa-home";
		$data['menu'] = 'projects';
		return $data;
	}

	protected function createViews()
	{
		$this->createViewsPartes();
		$this->createviewsVehiculos();
		$this->createviewsHorasTrajajo();
		$this->createviewsIncicencias();
	}

	protected function createViewsPartes(string $viewName = "ListPartes")
	{
		$this->addView($viewName, "Partes", "Ordenes de Instalacion");

		$this->setSettings($viewName, 'btnNew', false);

		// Ordenación
		$this->addOrderBy($viewName, ['id'], 'parte-numero', 1);           // Parte Nº (id)
		$this->addOrderBy($viewName, ['idproyecto'], 'proyecto');
		$this->addOrderBy($viewName, ['fechaapertura'], 'fecha-apertura');

		// Buscador por nombre y Nº de parte
		$this->addSearchFields($viewName, ['nombre', 'id']);

		// Filtro por estado (por defecto: abiertos)
		$this->addFilterSelectWhere($viewName, 'estado', [
			['label' => 'Abiertas', 'where' => [new DataBaseWhere('estado', 'Abierta')]],
			['label' => 'Pendientes', 'where' => [new DataBaseWhere('estado', 'Pendiente')]],
			['label' => 'Cerradas', 'where' => [new DataBaseWhere('estado', 'Cerrada')]],
			['label' => 'Todas', 'where' => []],
		]);

		// Filtro por periodo (fecha de apertura)
		$this->addFilterPeriod($viewName, 'periodo-apertura', 'Periodo apertura', 'fechaapertura');

		// Filtro por fecha de cierre
		$this->addFilterDatePicker($viewName, 'cierre-desde', 'Cierre desde', 'fechacierre', '>=');
		$this->addFilterDatePicker($viewName, 'cierre-hasta', 'Cierre hasta', 'fechacierre', '<=');

		// Filtro por proyecto
		$proyectos = $this->codeModel->all('proyectos', 'idproyecto', 'nombre');
		$this->addFilterSelect($viewName, 'idproyecto', 'Proyecto', 'idproyecto', $proyectos);
	}


	protected function createviewsVehiculos(): Closure
	{
		return function (string $viewName = 'EditOIVehiculoOrden') {
			$this->addEditListView($viewName, 'OIVehiculoOrden', 'vehiculos', 'fas fa-car');
		};
	}

	protected function createviewsHorasTrajajo(): Closure
	{
		return function (string $viewName = 'EditOIOperarioTarea') {
			$this->addEditListView($viewName, 'OIOperarioTarea', 'operarios', 'fas fa-user');
		};
	}

	protected function createviewsIncicencias(): Closure
	{
		return function (string $viewName = 'EditOIncidencia') {
			$this->addEditListView($viewName, 'OIncidencia', 'incidencias', 'fas fa-exclamation-triangle');
		};
	}


}
